/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolspower.modules.monitor.blocks;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.blocks.LogicSlabBlock;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.LogicSupport;
import mcjty.lib.tileentity.TickingTileEntity;
import mcjty.lib.varia.EnergyTools;
import mcjty.rftoolspower.compat.RFToolsPowerTOPDriver;
import mcjty.rftoolspower.modules.monitor.MonitorModule;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class PowerLevelTileEntity
extends TickingTileEntity {
    private final LogicSupport support = new LogicSupport();
    private int counter = 20;

    public PowerLevelTileEntity() {
        super((TileEntityType)MonitorModule.TYPE_POWER_LEVEL.get());
    }

    public static LogicSlabBlock createBlock() {
        return new LogicSlabBlock(new BlockBuilder().topDriver((TOPDriver)RFToolsPowerTOPDriver.DRIVER).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolsutility.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header()}).tileEntitySupplier(PowerLevelTileEntity::new));
    }

    public LogicSupport getLogicSupport() {
        return this.support;
    }

    public void checkRedstone(World world, BlockPos pos) {
        this.support.checkRedstone((GenericTileEntity)this, world, pos);
    }

    public int getRedstoneOutput(BlockState state, IBlockReader world, BlockPos pos, Direction side) {
        return this.support.getRedstoneOutput(state, side);
    }

    @Nonnull
    public CompoundNBT func_189517_E_() {
        CompoundNBT tag = super.func_189517_E_();
        tag.func_74768_a("power", this.support.getPowerOutput());
        return tag;
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        super.handleUpdateTag(state, tag);
        this.support.setPowerOutput(tag.func_74762_e("power"));
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 1, this.func_189517_E_());
    }

    public void saveClientDataToNBT(CompoundNBT tagCompound) {
        this.saveInfo(tagCompound);
    }

    public void loadClientDataFromNBT(CompoundNBT tagCompound) {
        this.loadInfo(tagCompound);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.handleUpdateTag(this.func_195044_w(), pkt.func_148857_g());
    }

    protected void tickServer() {
        --this.counter;
        if (this.counter > 0) {
            return;
        }
        this.counter = 20;
        Direction inputSide = LogicSupport.getFacing((BlockState)this.field_145850_b.func_180495_p(this.func_174877_v())).getInputSide();
        BlockPos inputPos = this.func_174877_v().func_177972_a(inputSide);
        TileEntity tileEntity = this.field_145850_b.func_175625_s(inputPos);
        if (!EnergyTools.isEnergyTE((TileEntity)tileEntity, null)) {
            this.support.setRedstoneState((GenericTileEntity)this, 0);
            return;
        }
        EnergyTools.EnergyLevel energy = EnergyTools.getEnergyLevelMulti((TileEntity)tileEntity, null);
        long maxEnergy = energy.getMaxEnergy();
        int ratio = 0;
        if (maxEnergy > 0L) {
            long stored = energy.getEnergy();
            ratio = (int)(stored * 10L / maxEnergy);
            if (ratio < 0) {
                ratio = 0;
            } else if (ratio > 9) {
                ratio = 9;
            }
        }
        if (this.support.getPowerOutput() != ratio) {
            this.support.setRedstoneState((GenericTileEntity)this, ratio);
            this.markDirtyClient();
        }
    }
}

