/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolspower.modules.generator.blocks;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.api.information.IPowerInformation;
import mcjty.lib.api.infusable.DefaultInfusable;
import mcjty.lib.api.infusable.IInfusable;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericItemHandler;
import mcjty.lib.container.SlotDefinition;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericEnergyStorage;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.TickingTileEntity;
import mcjty.lib.varia.EnergyTools;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.rftoolspower.compat.RFToolsPowerTOPDriver;
import mcjty.rftoolspower.modules.generator.CoalGeneratorConfig;
import mcjty.rftoolspower.modules.generator.CoalGeneratorModule;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;

public class CoalGeneratorTileEntity
extends TickingTileEntity {
    public static final int SLOT_COALINPUT = 0;
    public static final int SLOT_CHARGEITEM = 1;
    private static final Lazy<ContainerFactory> CONTAINER_FACTORY = Lazy.of(() -> new ContainerFactory(2).slot(SlotDefinition.specific(CoalGeneratorTileEntity::isValidFuel).in(), 0, 82, 24).slot(SlotDefinition.specific(EnergyTools::isEnergyItem).in().out(), 1, 118, 24).playerSlots(10, 70));
    @Cap(type=CapType.ITEMS_AUTOMATION)
    private final GenericItemHandler items = GenericItemHandler.create((GenericTileEntity)this, CONTAINER_FACTORY).itemValid((slot, stack) -> {
        if (slot == 0) {
            return CoalGeneratorTileEntity.isValidFuel(stack);
        }
        return EnergyTools.isEnergyItem((ItemStack)stack);
    }).build();
    @Cap(type=CapType.ENERGY)
    private final GenericEnergyStorage energyStorage = new GenericEnergyStorage((GenericTileEntity)this, false, (long)((Integer)CoalGeneratorConfig.MAXENERGY.get()).intValue(), 0L);
    @Cap(type=CapType.CONTAINER)
    private final LazyOptional<INamedContainerProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Coal Generator").containerSupplier(DefaultContainerProvider.container(CoalGeneratorModule.CONTAINER_COALGENERATOR, CONTAINER_FACTORY, (GenericTileEntity)this)).itemHandler(() -> this.items).energyHandler(() -> this.energyStorage).setupSync((GenericTileEntity)this));
    @Cap(type=CapType.INFUSABLE)
    private final IInfusable infusable = new DefaultInfusable((TileEntity)this);
    @Cap(type=CapType.POWER_INFO)
    private final LazyOptional<IPowerInformation> powerInfoHandler = LazyOptional.of(this::createPowerInfo);
    private int burning;

    public CoalGeneratorTileEntity() {
        super((TileEntityType)CoalGeneratorModule.TYPE_COALGENERATOR.get());
    }

    public static BaseBlock createBlock() {
        return new BaseBlock(new BlockBuilder().tileEntitySupplier(CoalGeneratorTileEntity::new).topDriver((TOPDriver)RFToolsPowerTOPDriver.DRIVER).infusable().manualEntry(ManualHelper.create((String)"rftoolspower:powergeneration/coalgenerator")).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolspower.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.gold(), TooltipBuilder.parameter((String)"info", stack -> Long.toString(((Integer)CoalGeneratorConfig.RFPERTICK.get()).intValue()) + " RF/FE")})){

            protected void func_206840_a(@Nonnull StateContainer.Builder<Block, BlockState> builder) {
                super.func_206840_a(builder);
                builder.func_206894_a(new Property[]{BlockStateProperties.field_208190_q});
            }
        };
    }

    protected boolean needsRedstoneMode() {
        return true;
    }

    public void setPowerInput(int powered) {
        boolean changed = this.powerLevel != powered;
        super.setPowerInput(powered);
        if (changed) {
            this.func_70296_d();
        }
    }

    protected void tickServer() {
        this.markDirtyQuick();
        this.handleChargingItem((IItemHandler)this.items);
        this.handleSendingEnergy();
        if (!this.isMachineEnabled()) {
            return;
        }
        this.handlePowerGeneration();
    }

    private void handlePowerGeneration() {
        if (this.burning > 0) {
            --this.burning;
            long rf = this.getRfPerTick();
            this.energyStorage.produceEnergy(rf);
        } else if (!this.items.getStackInSlot(0).func_190926_b()) {
            ItemStack extracted = this.items.extractItem(0, 1, false);
            this.burning = (Integer)CoalGeneratorConfig.TICKSPERCOAL.get();
            if (extracted.func_77973_b() == Blocks.field_150402_ci.func_199767_j()) {
                this.burning *= 9;
            }
            float factor = this.infusable.getInfusedFactor();
            this.burning += (int)((float)this.burning * factor / 2.0f);
        }
        BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208190_q)).booleanValue() != this.isWorking()) {
            this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208190_q, (Comparable)Boolean.valueOf(this.isWorking())), 3);
        }
    }

    public long getRfPerTick() {
        long rf = ((Integer)CoalGeneratorConfig.RFPERTICK.get()).intValue();
        float factor = this.infusable.getInfusedFactor();
        rf += (long)((float)rf * factor);
        return rf;
    }

    public boolean isWorking() {
        return this.burning > 0 && this.isMachineEnabled();
    }

    private void handleChargingItem(IItemHandler handler) {
        ItemStack stack = handler.getStackInSlot(1);
        if (!stack.func_190926_b()) {
            long storedPower = this.energyStorage.getEnergy();
            long rfToGive = Math.min((long)((Integer)CoalGeneratorConfig.CHARGEITEMPERTICK.get()).intValue(), storedPower);
            long received = EnergyTools.receiveEnergy((ItemStack)stack, (long)rfToGive);
            this.energyStorage.consumeEnergy(received);
        }
    }

    private void handleSendingEnergy() {
        long storedPower = this.energyStorage.getEnergy();
        EnergyTools.handleSendingEnergy((World)this.field_145850_b, (BlockPos)this.field_174879_c, (long)storedPower, (long)((Integer)CoalGeneratorConfig.SENDPERTICK.get()).intValue(), (GenericEnergyStorage)this.energyStorage);
    }

    public void load(CompoundNBT tagCompound) {
        super.load(tagCompound);
        CompoundNBT info = tagCompound.func_74775_l("Info");
        this.burning = info.func_74762_e("burning");
    }

    public void saveAdditional(@Nonnull CompoundNBT tagCompound) {
        super.saveAdditional(tagCompound);
        CompoundNBT infoTag = this.getOrCreateInfo(tagCompound);
        infoTag.func_74768_a("burning", this.burning);
    }

    @Nonnull
    private IPowerInformation createPowerInfo() {
        return new IPowerInformation(){

            public long getEnergyDiffPerTick() {
                return CoalGeneratorTileEntity.this.burning > 0 ? CoalGeneratorTileEntity.this.getRfPerTick() : 0L;
            }

            @Nullable
            public String getEnergyUnitName() {
                return "RF";
            }

            public boolean isMachineActive() {
                return CoalGeneratorTileEntity.this.isMachineEnabled();
            }

            public boolean isMachineRunning() {
                return CoalGeneratorTileEntity.this.isMachineEnabled();
            }

            @Nullable
            public String getMachineStatus() {
                return CoalGeneratorTileEntity.this.burning > 0 ? "generating power" : "idle";
            }
        };
    }

    private static boolean isValidFuel(@Nonnull ItemStack stack) {
        return stack.func_77973_b() == Items.field_151044_h || stack.func_77973_b() == Items.field_196155_l || stack.func_77973_b() == Items.field_221896_ff;
    }
}

