/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolspower.modules.endergenic.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import javax.annotation.Nonnull;
import mcjty.lib.blockcommands.ICommand;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.widgets.EnergyBar;
import mcjty.lib.gui.widgets.TextField;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.rftoolspower.modules.endergenic.EndergenicModule;
import mcjty.rftoolspower.modules.endergenic.blocks.EndergenicTileEntity;
import mcjty.rftoolspower.setup.RFToolsPowerMessages;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.util.ResourceLocation;

public class GuiEndergenic
extends GenericGuiContainer<EndergenicTileEntity, GenericContainer> {
    private EnergyBar energyBar;
    private TextField lastRfPerTick;
    private TextField lastLostPearls;
    private TextField lastLaunchedPearls;
    private TextField lastOpportunities;
    private int timer = 10;

    public GuiEndergenic(EndergenicTileEntity endergenicTileEntity, GenericContainer container, PlayerInventory inventory) {
        super((GenericTileEntity)endergenicTileEntity, (Container)container, inventory, ((BaseBlock)EndergenicModule.ENDERGENIC.get()).getManualEntry());
    }

    public static void register() {
        GuiEndergenic.register((ContainerType)((ContainerType)EndergenicModule.CONTAINER_ENDERGENIC.get()), GuiEndergenic::new);
    }

    public void func_231160_c_() {
        this.window = new Window((Screen)this, this.tileEntity, RFToolsPowerMessages.INSTANCE, new ResourceLocation("rftoolspower", "gui/endergenic.gui"));
        super.func_231160_c_();
        this.initializeFields();
    }

    private void initializeFields() {
        this.energyBar = (EnergyBar)this.window.findChild("energybar");
        this.lastRfPerTick = (TextField)this.window.findChild("lastrft");
        this.lastLostPearls = (TextField)this.window.findChild("lastlost");
        this.lastLaunchedPearls = (TextField)this.window.findChild("lastlaunched");
        this.lastOpportunities = (TextField)this.window.findChild("lastopp");
    }

    private void updateFields() {
        if (this.window == null) {
            return;
        }
        this.energyBar.maxValue(((EndergenicTileEntity)this.tileEntity).getCapacity());
        this.lastRfPerTick.text(((EndergenicTileEntity)this.tileEntity).clientLastRfPerTick + " RF/tick");
        this.lastLostPearls.text(((EndergenicTileEntity)this.tileEntity).clientLastPearlsLost + " pearls");
        this.lastLaunchedPearls.text(((EndergenicTileEntity)this.tileEntity).clientLastPearlsLaunched + " pearls");
        this.lastOpportunities.text(((EndergenicTileEntity)this.tileEntity).clientLastPearlOpportunities + " times");
    }

    protected void func_230450_a_(@Nonnull MatrixStack matrixStack, float v, int i, int i2) {
        this.updateFields();
        this.drawWindow(matrixStack);
        this.checkStats();
    }

    private void checkStats() {
        --this.timer;
        if (this.timer <= 0) {
            this.timer = 20;
            ((EndergenicTileEntity)this.tileEntity).requestDataFromServer(RFToolsPowerMessages.INSTANCE, (ICommand)EndergenicTileEntity.CMD_GETSTATS, TypedMap.EMPTY);
        }
        this.updateEnergyBar(this.energyBar);
    }
}

