/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.modules.dimlets.lootmodifier;

import com.google.gson.JsonObject;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import mcjty.rftoolsdim.modules.dimlets.data.DimletDictionary;
import mcjty.rftoolsdim.modules.dimlets.data.DimletKey;
import mcjty.rftoolsdim.modules.dimlets.data.DimletRarity;
import mcjty.rftoolsdim.modules.dimlets.data.DimletTools;
import mcjty.rftoolsdim.modules.knowledge.items.LostKnowledgeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;

public class EndermanLootModifier
extends LootModifier {
    private final float commonKnowledgeChance;
    private final float uncommonKnowledgeChance;
    private final float rareKnowledgeChance;
    private final float legendaryKnowledgeChance;
    private final float commonDimletChance;
    private final float uncommonDimletChance;
    private final float rareDimletChance;
    private final float legendaryDimletChance;

    public EndermanLootModifier(ILootCondition[] conditionsIn, float commonKnowledgeChance, float uncommonKnowledgeChance, float rareKnowledgeChance, float legendaryKnowledgeChance, float commonDimletChance, float uncommonDimletChance, float rareDimletChance, float legendaryDimletChance) {
        super(conditionsIn);
        this.commonKnowledgeChance = commonKnowledgeChance;
        this.uncommonKnowledgeChance = uncommonKnowledgeChance;
        this.rareKnowledgeChance = rareKnowledgeChance;
        this.legendaryKnowledgeChance = legendaryKnowledgeChance;
        this.commonDimletChance = commonDimletChance;
        this.uncommonDimletChance = uncommonDimletChance;
        this.rareDimletChance = rareDimletChance;
        this.legendaryDimletChance = legendaryDimletChance;
    }

    public float getCommonKnowledgeChance() {
        return this.commonKnowledgeChance;
    }

    public float getUncommonKnowledgeChance() {
        return this.uncommonKnowledgeChance;
    }

    public float getRareKnowledgeChance() {
        return this.rareKnowledgeChance;
    }

    public float getLegendaryKnowledgeChance() {
        return this.legendaryKnowledgeChance;
    }

    public float getCommonDimletChance() {
        return this.commonDimletChance;
    }

    public float getUncommonDimletChance() {
        return this.uncommonDimletChance;
    }

    public float getRareDimletChance() {
        return this.rareDimletChance;
    }

    public float getLegendaryDimletChance() {
        return this.legendaryDimletChance;
    }

    @Nonnull
    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        Random random = context.func_216032_b();
        this.spawnKnowledge(generatedLoot, context, random, this.commonKnowledgeChance, DimletRarity.COMMON);
        this.spawnKnowledge(generatedLoot, context, random, this.uncommonKnowledgeChance, DimletRarity.UNCOMMON);
        this.spawnKnowledge(generatedLoot, context, random, this.rareKnowledgeChance, DimletRarity.RARE);
        this.spawnKnowledge(generatedLoot, context, random, this.legendaryKnowledgeChance, DimletRarity.LEGENDARY);
        this.spawnDimlet(generatedLoot, context, random, this.commonDimletChance, DimletRarity.COMMON);
        this.spawnDimlet(generatedLoot, context, random, this.uncommonDimletChance, DimletRarity.UNCOMMON);
        this.spawnDimlet(generatedLoot, context, random, this.rareDimletChance, DimletRarity.RARE);
        this.spawnDimlet(generatedLoot, context, random, this.legendaryDimletChance, DimletRarity.LEGENDARY);
        return generatedLoot;
    }

    private void spawnKnowledge(List<ItemStack> generatedLoot, LootContext context, Random random, float chance, DimletRarity rarity) {
        ItemStack stack;
        if (random.nextFloat() < chance && !(stack = LostKnowledgeItem.createUnresearchedLostKnowledge(rarity)).func_190926_b()) {
            generatedLoot.add(stack);
        }
    }

    private void spawnDimlet(List<ItemStack> generatedLoot, LootContext context, Random random, float chance, DimletRarity rarity) {
        DimletKey key;
        if (random.nextFloat() < chance && (key = DimletDictionary.get().getRandomDimlet(rarity, random)) != null) {
            generatedLoot.add(DimletTools.getDimletStack(key));
        }
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<EndermanLootModifier> {
        public EndermanLootModifier read(ResourceLocation name, JsonObject object, ILootCondition[] conditionsIn) {
            float commonKnowledgeChance = JSONUtils.func_151217_k((JsonObject)object, (String)"commonKnowledgeChance");
            float uncommonKnowledgeChance = JSONUtils.func_151217_k((JsonObject)object, (String)"uncommonKnowledgeChance");
            float rareKnowledgeChance = JSONUtils.func_151217_k((JsonObject)object, (String)"rareKnowledgeChance");
            float legendaryKnowledgeChance = JSONUtils.func_151217_k((JsonObject)object, (String)"legendaryKnowledgeChance");
            float commonDimletChance = JSONUtils.func_151217_k((JsonObject)object, (String)"commonDimletChance");
            float uncommonDimletChance = JSONUtils.func_151217_k((JsonObject)object, (String)"uncommonDimletChance");
            float rareDimletChance = JSONUtils.func_151217_k((JsonObject)object, (String)"rareDimletChance");
            float legendaryDimletChance = JSONUtils.func_151217_k((JsonObject)object, (String)"legendaryDimletChance");
            return new EndermanLootModifier(conditionsIn, commonKnowledgeChance, uncommonKnowledgeChance, rareKnowledgeChance, legendaryKnowledgeChance, commonDimletChance, uncommonDimletChance, rareDimletChance, legendaryDimletChance);
        }

        public JsonObject write(EndermanLootModifier instance) {
            JsonObject object = this.makeConditions(instance.conditions);
            object.addProperty("commonKnowledgeChance", (Number)Float.valueOf(instance.getCommonKnowledgeChance()));
            object.addProperty("uncommonKnowledgeChance", (Number)Float.valueOf(instance.getUncommonKnowledgeChance()));
            object.addProperty("rareKnowledgeChance", (Number)Float.valueOf(instance.getRareKnowledgeChance()));
            object.addProperty("legendaryKnowledgeChance", (Number)Float.valueOf(instance.getLegendaryKnowledgeChance()));
            object.addProperty("commonDimletChance", (Number)Float.valueOf(instance.getCommonDimletChance()));
            object.addProperty("uncommonDimletChance", (Number)Float.valueOf(instance.getUncommonDimletChance()));
            object.addProperty("rareDimletChance", (Number)Float.valueOf(instance.getRareDimletChance()));
            object.addProperty("legendaryDimletChance", (Number)Float.valueOf(instance.getLegendaryDimletChance()));
            return object;
        }
    }
}

