/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.modules.dimlets.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import mcjty.lib.varia.LevelTools;
import mcjty.rftoolsdim.modules.dimlets.data.DimletKey;
import mcjty.rftoolsdim.modules.dimlets.data.DimletPackages;
import mcjty.rftoolsdim.modules.dimlets.data.DimletRarity;
import mcjty.rftoolsdim.modules.dimlets.data.DimletSettings;
import mcjty.rftoolsdim.modules.dimlets.data.DimletTools;
import mcjty.rftoolsdim.modules.dimlets.data.DimletType;
import mcjty.rftoolsdim.modules.knowledge.data.DimletPattern;
import mcjty.rftoolsdim.modules.knowledge.data.KnowledgeManager;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;

public class DimletDictionary {
    private static final DimletDictionary INSTANCE = new DimletDictionary();
    private final Map<DimletKey, DimletSettings> dimlets = new HashMap<DimletKey, DimletSettings>();
    private final Map<DimletRarity, List<DimletKey>> dimletsByRarity = new HashMap<DimletRarity, List<DimletKey>>();
    private final Map<Pair<DimletType, DimletRarity>, List<DimletKey>> dimletsByRarityAndType = new HashMap<Pair<DimletType, DimletRarity>, List<DimletKey>>();

    public static DimletDictionary get() {
        return INSTANCE;
    }

    public void reset() {
        this.dimlets.clear();
        this.dimletsByRarity.clear();
        this.dimletsByRarityAndType.clear();
    }

    public boolean register(DimletKey key, DimletSettings settings) {
        if (DimletTools.isValidDimlet(key)) {
            this.dimlets.put(key, settings);
            return true;
        }
        return false;
    }

    public Set<DimletKey> getDimlets() {
        return this.dimlets.keySet();
    }

    public DimletSettings getSettings(DimletKey key) {
        return this.dimlets.get(key);
    }

    public DimletKey tryCraft(World world, DimletType type, ItemStack memoryPart, ItemStack energyPart, ItemStack essence, DimletPattern pattern) {
        for (Map.Entry<DimletKey, DimletSettings> entry : this.dimlets.entrySet()) {
            DimletPattern neededPattern;
            ItemStack neededEssence;
            DimletKey key = entry.getKey();
            if (!type.equals((Object)key.getType()) || !memoryPart.func_77969_a(DimletTools.getNeededMemoryPart(key)) || !energyPart.func_77969_a(DimletTools.getNeededEnergyPart(key)) || !DimletTools.isFullEssence(essence, neededEssence = DimletTools.getNeededEssence(key, entry.getValue()), key.getKey()) || !Objects.equals(neededPattern = KnowledgeManager.get().getPattern(LevelTools.getOverworld((World)world).func_72905_C(), key), pattern)) continue;
            return key;
        }
        return null;
    }

    @Nullable
    public DimletKey getRandomDimlet(DimletRarity rarity, Random random) {
        List<DimletKey> keys = this.getDimletsByRarity(rarity);
        if (keys.isEmpty()) {
            return null;
        }
        if (keys.size() == 1) {
            return keys.get(0);
        }
        DimletKey dimletKey = null;
        for (int i = 0; i < Math.max(2, Math.min(10, keys.size() / 20)); ++i) {
            dimletKey = keys.get(random.nextInt(keys.size()));
            if (dimletKey.getType() == DimletType.BLOCK) continue;
            return dimletKey;
        }
        return dimletKey;
    }

    @Nullable
    public DimletKey getRandomDimlet(DimletType type, Random random) {
        DimletKey key = this.getRandomDimletInternal(type, DimletRarity.COMMON, random);
        if (key == null && (key = this.getRandomDimletInternal(type, DimletRarity.UNCOMMON, random)) == null && (key = this.getRandomDimletInternal(type, DimletRarity.RARE, random)) == null) {
            key = this.getRandomDimletInternal(type, DimletRarity.LEGENDARY, random);
        }
        return key;
    }

    private DimletKey getRandomDimletInternal(DimletType type, DimletRarity startAt, Random random) {
        DimletRarity rarity = startAt;
        if (random.nextFloat() < 0.1f) {
            rarity = DimletRarity.UNCOMMON;
            if (random.nextFloat() < 0.1f) {
                rarity = DimletRarity.RARE;
                if (random.nextFloat() < 0.1f) {
                    rarity = DimletRarity.LEGENDARY;
                }
            }
        }
        while (true) {
            List<DimletKey> keys;
            if (!(keys = this.getDimletsByRarityAndType(type, rarity)).isEmpty()) {
                if (keys.size() == 1) {
                    return keys.get(0);
                }
                return keys.get(random.nextInt(keys.size()));
            }
            switch (rarity) {
                case COMMON: {
                    return null;
                }
                case UNCOMMON: {
                    rarity = DimletRarity.COMMON;
                    break;
                }
                case RARE: {
                    rarity = DimletRarity.UNCOMMON;
                    break;
                }
                case LEGENDARY: {
                    rarity = DimletRarity.RARE;
                }
            }
        }
    }

    private List<DimletKey> getDimletsByRarity(DimletRarity rarity) {
        if (!this.dimletsByRarity.containsKey((Object)rarity)) {
            ArrayList<DimletKey> dimletKeys = new ArrayList<DimletKey>();
            for (Map.Entry<DimletKey, DimletSettings> entry : this.dimlets.entrySet()) {
                DimletKey key;
                if (entry.getValue().getRarity() != rarity || !this.getSettings(key = entry.getKey()).isWorldgen()) continue;
                dimletKeys.add(key);
            }
            this.dimletsByRarity.put(rarity, dimletKeys);
        }
        return this.dimletsByRarity.get((Object)rarity);
    }

    private List<DimletKey> getDimletsByRarityAndType(DimletType type, DimletRarity rarity) {
        Pair pair = Pair.of((Object)((Object)type), (Object)((Object)rarity));
        if (!this.dimletsByRarityAndType.containsKey(pair)) {
            ArrayList<DimletKey> dimletKeys = new ArrayList<DimletKey>();
            List<DimletKey> dimletsByRarity = this.getDimletsByRarity(rarity);
            for (DimletKey key : dimletsByRarity) {
                if (key.getType() != type) continue;
                dimletKeys.add(key);
            }
            this.dimletsByRarityAndType.put((Pair<DimletType, DimletRarity>)pair, dimletKeys);
        }
        return this.dimletsByRarityAndType.get(pair);
    }

    public void readPackage(String filename) {
        DimletPackages.readPackage(filename, this::register);
    }

    @Nullable
    public DimletKey getBlockDimlet(String block) {
        for (Map.Entry<DimletKey, DimletSettings> entry : this.dimlets.entrySet()) {
            DimletKey key = entry.getKey();
            if (!key.getType().equals((Object)DimletType.BLOCK) || !Objects.equals(key.getKey(), block)) continue;
            return key;
        }
        return null;
    }

    @Nullable
    public DimletKey getFluidDimlet(String fluid) {
        for (Map.Entry<DimletKey, DimletSettings> entry : this.dimlets.entrySet()) {
            DimletKey key = entry.getKey();
            if (!key.getType().equals((Object)DimletType.FLUID) || !Objects.equals(key.getKey(), fluid)) continue;
            return key;
        }
        return null;
    }

    @Nullable
    public DimletKey getBiomeDimlet(String biomeId) {
        for (Map.Entry<DimletKey, DimletSettings> entry : this.dimlets.entrySet()) {
            DimletKey key = entry.getKey();
            if (!key.getType().equals((Object)DimletType.BIOME) || !Objects.equals(key.getKey(), biomeId)) continue;
            return key;
        }
        return null;
    }
}

