/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.dimension.terraintypes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import javax.annotation.Nonnull;
import mcjty.rftoolsdim.dimension.data.DimensionSettings;
import mcjty.rftoolsdim.dimension.terraintypes.AttributeType;
import mcjty.rftoolsdim.dimension.terraintypes.BaseChunkGenerator;
import mcjty.rftoolsdim.dimension.tools.OffsetBlockReader;
import net.minecraft.block.BlockState;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.RegistryLookupCodec;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.structure.StructureManager;

public class FlatChunkGenerator
extends BaseChunkGenerator {
    public static final Codec<FlatChunkGenerator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RegistryLookupCodec.func_244331_a((RegistryKey)Registry.field_239720_u_).forGetter(BaseChunkGenerator::getBiomeRegistry), (App)DimensionSettings.SETTINGS_CODEC.fieldOf("settings").forGetter(BaseChunkGenerator::getDimensionSettings)).apply((Applicative)instance, FlatChunkGenerator::new));
    public static final int FLAT_LEVEL = 64;

    public FlatChunkGenerator(MinecraftServer server, DimensionSettings settings) {
        this((Registry<Biome>)server.func_244267_aX().func_243612_b(Registry.field_239720_u_), settings);
    }

    public FlatChunkGenerator(Registry<Biome> registry, DimensionSettings settings) {
        super(registry, settings);
    }

    @Nonnull
    protected Codec<? extends ChunkGenerator> func_230347_a_() {
        return CODEC;
    }

    @Nonnull
    public ChunkGenerator func_230349_a_(long l) {
        return new FlatChunkGenerator(this.getBiomeRegistry(), this.getDimensionSettings());
    }

    public void func_230352_b_(@Nonnull IWorld iWorld, @Nonnull StructureManager structureManager, IChunk chunk) {
        BlockPos.Mutable mpos = new BlockPos.Mutable();
        Heightmap hmOcean = chunk.func_217303_b(Heightmap.Type.OCEAN_FLOOR_WG);
        Heightmap hmWorld = chunk.func_217303_b(Heightmap.Type.WORLD_SURFACE_WG);
        Set<AttributeType> attributeTypes = this.field_222543_d.getCompiledDescriptor().getAttributeTypes();
        boolean flatter = attributeTypes.contains((Object)AttributeType.FLATTER);
        boolean elevated = attributeTypes.contains((Object)AttributeType.ELEVATED);
        int flatLevel = 64;
        if (flatter) {
            flatLevel /= 2;
        } else if (elevated) {
            flatLevel *= 2;
        }
        for (int y = 0; y <= flatLevel; ++y) {
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    BlockState state = this.getDefaultBlock();
                    chunk.func_177436_a((BlockPos)mpos.func_181079_c(x, y, z), state, false);
                    hmOcean.func_202270_a(x, y, z, state);
                    hmWorld.func_202270_a(x, y, z, state);
                }
            }
        }
    }

    public int func_222529_a(int x, int z, @Nonnull Heightmap.Type type) {
        for (int i = 64; i >= 0; --i) {
            BlockState blockstate = (BlockState)this.defaultBlocks.get(0);
            if (!type.func_222684_d().test(blockstate)) continue;
            return i + 1;
        }
        return 0;
    }

    @Nonnull
    public IBlockReader func_230348_a_(int x, int z) {
        return new OffsetBlockReader((BlockState)this.defaultBlocks.get(0), 64);
    }
}

