/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.various.items.interactionmodule;

import java.util.Objects;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.LevelTools;
import mcjty.rftoolsbase.api.screens.IScreenDataHelper;
import mcjty.rftoolsbase.api.screens.IScreenModule;
import mcjty.rftoolsbase.api.screens.data.IModuleDataBoolean;
import mcjty.rftoolscontrol.modules.processor.ProcessorModule;
import mcjty.rftoolscontrol.modules.processor.blocks.ProcessorTileEntity;
import mcjty.rftoolscontrol.setup.Config;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class InteractionScreenModule
implements IScreenModule<IModuleDataBoolean> {
    private BlockPos coordinate = BlockPosTools.INVALID;
    private String line = "";
    private String signal = "";

    public IModuleDataBoolean getData(IScreenDataHelper helper, World worldObj, long millis) {
        return null;
    }

    public void setupFromNBT(CompoundNBT tagCompound, RegistryKey<World> dim, BlockPos pos) {
        if (tagCompound != null) {
            this.line = tagCompound.func_74779_i("text");
            this.signal = tagCompound.func_74779_i("signal");
            this.coordinate = BlockPosTools.INVALID;
            if (tagCompound.func_74764_b("monitorx")) {
                RegistryKey dim1 = World.field_234918_g_;
                dim1 = tagCompound.func_74764_b("monitordim") ? LevelTools.getId((String)tagCompound.func_74779_i("monitordim")) : LevelTools.getId((String)tagCompound.func_74779_i("dim"));
                if (Objects.equals(dim, dim1)) {
                    BlockPos c = new BlockPos(tagCompound.func_74762_e("monitorx"), tagCompound.func_74762_e("monitory"), tagCompound.func_74762_e("monitorz"));
                    int dx = Math.abs(c.func_177958_n() - pos.func_177958_n());
                    int dy = Math.abs(c.func_177956_o() - pos.func_177956_o());
                    int dz = Math.abs(c.func_177952_p() - pos.func_177952_p());
                    if (dx <= 64 && dy <= 64 && dz <= 64) {
                        this.coordinate = c;
                    }
                }
            }
        }
    }

    public int getRfPerTick() {
        return (Integer)Config.INTERACTMODULE_RFPERTICK.get();
    }

    public void mouseClick(World world, int x, int y, boolean clicked, PlayerEntity player) {
        int xoffset = !this.line.isEmpty() ? 80 : 5;
        if (x >= xoffset) {
            if (this.coordinate.func_177956_o() != -1) {
                TileEntity te;
                if (!LevelTools.isLoaded((World)world, (BlockPos)this.coordinate)) {
                    return;
                }
                Block block = world.func_180495_p(this.coordinate).func_177230_c();
                if (block != ProcessorModule.PROCESSOR.get()) {
                    return;
                }
                if (clicked && (te = world.func_175625_s(this.coordinate)) instanceof ProcessorTileEntity) {
                    ProcessorTileEntity processor = (ProcessorTileEntity)te;
                    processor.signal(this.signal);
                }
            } else if (player != null) {
                player.func_146105_b((ITextComponent)new StringTextComponent(TextFormatting.RED + "Module is not linked to a processor!"), false);
            }
        }
    }
}

