/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.various.blocks;

import javax.annotation.Nonnull;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.bindings.GuiValue;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.varia.BlockPosTools;
import mcjty.rftoolscontrol.modules.processor.blocks.ProcessorTileEntity;
import mcjty.rftoolscontrol.modules.various.VariousModule;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.util.LazyOptional;

public class NodeTileEntity
extends GenericTileEntity {
    @GuiValue
    private String channel;
    @GuiValue
    private String node;
    private BlockPos processor = null;
    private int prevIn = 0;
    private int[] powerOut = new int[]{0, 0, 0, 0, 0, 0};
    @Cap(type=CapType.CONTAINER)
    private final LazyOptional<INamedContainerProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Node").containerSupplier(DefaultContainerProvider.empty(VariousModule.NODE_CONTAINER, (GenericTileEntity)this)).setupSync((GenericTileEntity)this));

    public NodeTileEntity() {
        super((TileEntityType)VariousModule.NODE_TILE.get());
    }

    public String getNodeName() {
        return this.node;
    }

    public String getChannelName() {
        return this.channel;
    }

    public void setChannelName(String channel) {
        this.channel = channel;
        this.func_70296_d();
    }

    public void setNodeName(String node) {
        this.node = node;
        this.func_70296_d();
    }

    public BlockPos getProcessor() {
        return this.processor;
    }

    public void setProcessor(BlockPos processor) {
        this.processor = processor;
        this.func_70296_d();
    }

    public void setPowerInput(int powered) {
        if (this.powerLevel != powered) {
            TileEntity te;
            if (this.processor != null && (te = this.func_145831_w().func_175625_s(this.processor)) instanceof ProcessorTileEntity) {
                ProcessorTileEntity processorTileEntity = (ProcessorTileEntity)te;
                processorTileEntity.redstoneNodeChange(this.prevIn, powered, this.node);
            }
            this.prevIn = powered;
        }
        super.setPowerInput(powered);
    }

    public int getPowerOut(Direction side) {
        return this.powerOut[side.ordinal()];
    }

    public void setPowerOut(Direction side, int powerOut) {
        this.powerOut[side.ordinal()] = powerOut;
        this.func_70296_d();
        this.func_145831_w().func_190524_a(this.field_174879_c.func_177972_a(side), this.func_195044_w().func_177230_c(), this.field_174879_c);
    }

    public void load(CompoundNBT tagCompound) {
        super.load(tagCompound);
        this.prevIn = tagCompound.func_74762_e("prevIn");
        for (int i = 0; i < 6; ++i) {
            this.powerOut[i] = tagCompound.func_74771_c("p" + i);
        }
    }

    protected void loadInfo(CompoundNBT tagCompound) {
        super.loadInfo(tagCompound);
        CompoundNBT info = tagCompound.func_74775_l("Info");
        this.channel = info.func_74779_i("channel");
        this.node = info.func_74779_i("node");
        this.processor = BlockPosTools.read((CompoundNBT)info, (String)"processor");
    }

    public void saveAdditional(@Nonnull CompoundNBT tagCompound) {
        super.saveAdditional(tagCompound);
        tagCompound.func_74768_a("prevIn", this.prevIn);
        for (int i = 0; i < 6; ++i) {
            tagCompound.func_74774_a("p" + i, (byte)this.powerOut[i]);
        }
    }

    protected void saveInfo(CompoundNBT tagCompound) {
        super.saveInfo(tagCompound);
        CompoundNBT info = this.getOrCreateInfo(tagCompound);
        if (this.channel != null) {
            info.func_74778_a("channel", this.channel);
        }
        if (this.node != null) {
            info.func_74778_a("node", this.node);
        }
        if (this.processor != null) {
            BlockPosTools.write((CompoundNBT)info, (String)"processor", (BlockPos)this.processor);
        }
    }
}

