/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.processor.network;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.SafeClientTools;
import mcjty.rftoolscontrol.modules.processor.blocks.ProcessorContainer;
import mcjty.rftoolscontrol.modules.processor.network.PacketGetFluids;
import net.minecraft.inventory.container.Container;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketFluidsReady {
    private BlockPos pos;
    private List<PacketGetFluids.FluidEntry> list;
    private String command;

    public PacketFluidsReady(PacketBuffer buf) {
        if (buf.readBoolean()) {
            this.pos = buf.func_179259_c();
        }
        this.command = buf.func_150789_c(Short.MAX_VALUE);
        int size = buf.readInt();
        if (size != -1) {
            this.list = new ArrayList<PacketGetFluids.FluidEntry>(size);
            for (int i = 0; i < size; ++i) {
                this.list.add(PacketGetFluids.FluidEntry.fromPacket(buf));
            }
        } else {
            this.list = null;
        }
    }

    public PacketFluidsReady(@Nullable BlockPos pos, String command, List<PacketGetFluids.FluidEntry> list) {
        this.pos = pos;
        this.command = command;
        this.list = new ArrayList<PacketGetFluids.FluidEntry>();
        this.list.addAll(list);
    }

    public void toBytes(PacketBuffer buf) {
        if (this.pos != null) {
            buf.writeBoolean(true);
            buf.func_179255_a(this.pos);
        } else {
            buf.writeBoolean(false);
        }
        buf.func_180714_a(this.command);
        if (this.list == null) {
            buf.writeInt(-1);
        } else {
            buf.writeInt(this.list.size());
            for (PacketGetFluids.FluidEntry item : this.list) {
                PacketGetFluids.FluidEntry.toPacket(buf, item);
            }
        }
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            TileEntity te;
            if (this.pos == null) {
                ProcessorContainer container = PacketFluidsReady.getOpenContainer();
                if (container == null) {
                    Logging.log((String)"Container is missing!");
                    return;
                }
                te = container.getTe();
            } else {
                te = SafeClientTools.getClientWorld().func_175625_s(this.pos);
            }
            if (te instanceof GenericTileEntity) {
                ((GenericTileEntity)te).handleListFromServer(this.command, SafeClientTools.getClientPlayer(), TypedMap.EMPTY, this.list);
            }
        });
        ctx.setPacketHandled(true);
    }

    private static ProcessorContainer getOpenContainer() {
        Container container = SafeClientTools.getClientPlayer().field_71070_bA;
        if (container instanceof ProcessorContainer) {
            return (ProcessorContainer)container;
        }
        return null;
    }
}

