/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.processor.logic.editors;

import mcjty.lib.gui.Window;
import mcjty.lib.gui.widgets.ChoiceLabel;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.TextField;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.gui.widgets.Widgets;
import mcjty.rftoolsbase.api.control.parameters.Inventory;
import mcjty.rftoolsbase.api.control.parameters.ParameterType;
import mcjty.rftoolsbase.api.control.parameters.ParameterValue;
import mcjty.rftoolscontrol.modules.processor.logic.editors.AbstractParameterEditor;
import mcjty.rftoolscontrol.modules.processor.logic.editors.ParameterEditorCallback;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.Direction;
import org.apache.commons.lang3.StringUtils;

public class InventoryEditor
extends AbstractParameterEditor {
    private TextField nameLabel;
    private ChoiceLabel sideLabel;
    private ChoiceLabel intSideLabel;

    private static Inventory parseInventorySafe(String name, String sideS, String intSideS) {
        if ("*".equals(sideS)) {
            return null;
        }
        Direction side = Direction.func_176739_a((String)StringUtils.lowerCase((String)sideS));
        Direction intSide = "*".equals(intSideS) ? null : Direction.func_176739_a((String)StringUtils.lowerCase((String)intSideS));
        return new Inventory(name, side, intSide);
    }

    @Override
    public void initialFocusInternal(Window window) {
        window.setTextFocus((Widget)this.nameLabel);
    }

    @Override
    public int getHeight() {
        return 50;
    }

    @Override
    public void build(Minecraft mc, Screen gui, Panel panel, ParameterEditorCallback callback) {
        Panel constantPanel = Widgets.vertical();
        this.nameLabel = (TextField)((TextField)new TextField().event(text -> callback.valueChanged(this.readValue())).addTextEnterEvent(newText -> this.closeWindow()).desiredWidth(50)).desiredHeight(14);
        constantPanel.children(new Widget[]{this.createLabeledPanel(mc, gui, "Node name:", (Widget<?>)this.nameLabel, "Optional name of a node in the network")});
        this.sideLabel = (ChoiceLabel)new ChoiceLabel().choices(new String[]{"*", "Down", "Up", "North", "South", "West", "East"}).event(newChoice -> callback.valueChanged(this.readValue())).desiredWidth(60);
        constantPanel.children(new Widget[]{this.createLabeledPanel(mc, gui, "Side:", (Widget<?>)this.sideLabel, "Side relative to processor or node", "for the desired inventory")});
        this.intSideLabel = (ChoiceLabel)new ChoiceLabel().choices(new String[]{"*", "Down", "Up", "North", "South", "West", "East"}).event(newChoice -> callback.valueChanged(this.readValue())).desiredWidth(60);
        constantPanel.children(new Widget[]{this.createLabeledPanel(mc, gui, "Access:", (Widget<?>)this.intSideLabel, "Optional side from which we want to", "access the given inventory")});
        this.createEditorPanel(mc, gui, panel, callback, constantPanel, ParameterType.PAR_INVENTORY);
    }

    @Override
    protected ParameterValue readConstantValue() {
        return ParameterValue.constant((Object)InventoryEditor.parseInventorySafe(this.nameLabel.getText(), this.sideLabel.getCurrentChoice(), this.intSideLabel.getCurrentChoice()));
    }

    @Override
    protected void writeConstantValue(ParameterValue value) {
        if (value == null || value.getValue() == null) {
            this.sideLabel.choice("*");
        } else {
            Inventory inv = (Inventory)value.getValue();
            this.nameLabel.text(inv.getNodeNameSafe());
            this.sideLabel.choice(StringUtils.capitalize((String)inv.getSide().toString()));
            if (inv.getIntSide() == null) {
                this.intSideLabel.choice("*");
            } else {
                this.intSideLabel.choice(StringUtils.capitalize((String)inv.getIntSide().toString()));
            }
        }
    }
}

