/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.processor.logic.editors;

import javax.annotation.Nonnull;
import mcjty.lib.gui.events.BlockRenderEvent;
import mcjty.lib.gui.widgets.BlockRender;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.gui.widgets.Widgets;
import mcjty.rftoolsbase.api.control.parameters.ParameterType;
import mcjty.rftoolsbase.api.control.parameters.ParameterValue;
import mcjty.rftoolscontrol.modules.processor.logic.editors.AbstractParameterEditor;
import mcjty.rftoolscontrol.modules.processor.logic.editors.ParameterEditorCallback;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;

public class FluidEditor
extends AbstractParameterEditor {
    private BlockRender blockRender;

    @Override
    public void build(Minecraft mc, Screen gui, Panel panel, final ParameterEditorCallback callback) {
        Panel constantPanel = Widgets.horizontal();
        Label label = Widgets.label((String)"Drop bucket:");
        constantPanel.children(new Widget[]{label});
        this.blockRender = ((BlockRender)((BlockRender)((BlockRender)((BlockRender)new BlockRender().desiredWidth(118)).desiredHeight(18)).filledRectThickness(1)).filledBackground(-11184811)).showLabel(true);
        constantPanel.children(new Widget[]{this.blockRender});
        this.blockRender.event(new BlockRenderEvent(){

            public void select() {
                ItemStack holding = Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70445_o();
                if (holding.func_190926_b()) {
                    FluidEditor.this.blockRender.renderItem(null);
                } else {
                    FluidEditor.this.blockRender.renderItem((Object)FluidEditor.this.stackToFluid(holding));
                }
                callback.valueChanged(FluidEditor.this.readValue());
            }

            public void doubleClick() {
            }
        });
        this.createEditorPanel(mc, gui, panel, callback, constantPanel, ParameterType.PAR_FLUID);
    }

    @Override
    protected ParameterValue readConstantValue() {
        Object renderItem = this.blockRender.getRenderItem();
        if (renderItem instanceof ItemStack) {
            FluidStack fluidStack = this.stackToFluid((ItemStack)renderItem);
            return ParameterValue.constant((Object)fluidStack);
        }
        if (renderItem instanceof FluidStack) {
            FluidStack stack = (FluidStack)renderItem;
            return ParameterValue.constant((Object)stack);
        }
        return ParameterValue.constant(null);
    }

    @Nonnull
    private FluidStack stackToFluid(ItemStack stack) {
        return stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).map(handler -> {
            if (handler.getTanks() > 0) {
                return handler.getFluidInTank(0);
            }
            return FluidStack.EMPTY;
        }).orElseGet(() -> stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).map(handler -> {
            if (handler.getTanks() > 0) {
                return handler.getFluidInTank(0);
            }
            return FluidStack.EMPTY;
        }).orElse(FluidStack.EMPTY));
    }

    @Override
    protected void writeConstantValue(ParameterValue value) {
        if (value == null || value.getValue() == null) {
            this.blockRender.renderItem(null);
        } else {
            FluidStack inv = (FluidStack)value.getValue();
            this.blockRender.renderItem((Object)inv);
        }
    }
}

