/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.processor.logic;

import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import mcjty.lib.blockcommands.ISerializer;
import mcjty.rftoolsbase.api.control.parameters.IParameter;
import mcjty.rftoolsbase.api.control.parameters.ParameterType;
import mcjty.rftoolsbase.api.control.parameters.ParameterValue;
import mcjty.rftoolscontrol.modules.processor.logic.ParameterTools;
import mcjty.rftoolscontrol.modules.processor.logic.TypeConverters;
import net.minecraft.network.PacketBuffer;

public class Parameter
implements IParameter {
    private final ParameterType parameterType;
    private final ParameterValue parameterValue;

    private Parameter(Builder builder) {
        this.parameterType = builder.parameterType;
        this.parameterValue = builder.parameterValue;
    }

    public int compareTo(@Nonnull IParameter parameter) {
        switch (this.parameterType) {
            case PAR_STRING: {
                return TypeConverters.convertToString(this).compareTo(TypeConverters.convertToString(parameter));
            }
            case PAR_INTEGER: {
                return Integer.compare(TypeConverters.convertToInt(this), TypeConverters.convertToInt(parameter));
            }
            case PAR_FLOAT: {
                return Float.compare(TypeConverters.convertToFloat(this), TypeConverters.convertToFloat(parameter));
            }
            case PAR_SIDE: {
                return Objects.compare(TypeConverters.convertToSide(this), TypeConverters.convertToSide(parameter), Comparator.naturalOrder());
            }
            case PAR_BOOLEAN: {
                return Boolean.compare(TypeConverters.convertToBool(this), TypeConverters.convertToBool(parameter));
            }
            case PAR_INVENTORY: {
                return 0;
            }
            case PAR_ITEM: {
                return Objects.compare(TypeConverters.convertToItem(this), TypeConverters.convertToItem(parameter), Comparator.comparing(s -> s.func_77973_b().getRegistryName()));
            }
            case PAR_EXCEPTION: {
                return 0;
            }
            case PAR_TUPLE: {
                return Objects.compare(TypeConverters.convertToTuple(this), TypeConverters.convertToTuple(parameter), Comparator.naturalOrder());
            }
            case PAR_FLUID: {
                return Objects.compare(TypeConverters.convertToFluid(this), TypeConverters.convertToFluid(parameter), Comparator.comparing(s -> s.getFluid().getRegistryName().toString()));
            }
            case PAR_VECTOR: {
                return Objects.compare(TypeConverters.convertToVector(this), TypeConverters.convertToVector(parameter), Parameter::compareLists);
            }
            case PAR_LONG: {
                return Long.compare(TypeConverters.convertToLong(this), TypeConverters.convertToLong(parameter));
            }
            case PAR_NUMBER: {
                return Objects.compare(TypeConverters.convertToNumber(this), TypeConverters.convertToNumber(parameter), (n1, n2) -> {
                    Double d1 = n1.doubleValue();
                    Double d2 = n2.doubleValue();
                    return Objects.compare(d1, d2, Comparator.naturalOrder());
                });
            }
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Parameter parameter = (Parameter)o;
        return this.parameterType == parameter.parameterType && Objects.equals(this.parameterValue, parameter.parameterValue);
    }

    public int hashCode() {
        return Objects.hash(this.parameterType, this.parameterValue);
    }

    private static int compareLists(List<Parameter> l1, List<Parameter> l2) {
        int i;
        for (i = 0; i < l1.size() && i < l2.size(); ++i) {
            int rc = Objects.compare(l1.get(i), l2.get(i), Comparator.naturalOrder());
            if (rc == 0) continue;
            return rc;
        }
        if (i < l1.size()) {
            return 1;
        }
        if (i < l2.size()) {
            return -1;
        }
        return 0;
    }

    public boolean isSet() {
        return this.parameterValue != null && this.parameterValue.getValue() != null;
    }

    public ParameterType getParameterType() {
        return this.parameterType;
    }

    public ParameterValue getParameterValue() {
        return this.parameterValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private ParameterType parameterType;
        private ParameterValue parameterValue;

        public Builder type(ParameterType parameterType) {
            this.parameterType = parameterType;
            return this;
        }

        public Builder value(ParameterValue value) {
            this.parameterValue = value;
            return this;
        }

        public Parameter build() {
            return new Parameter(this);
        }
    }

    public static class Serializer
    implements ISerializer<Parameter> {
        public Function<PacketBuffer, Parameter> getDeserializer() {
            return ParameterTools::readFromBuf;
        }

        public BiConsumer<PacketBuffer, Parameter> getSerializer() {
            return ParameterTools::writeToBuf;
        }
    }
}

