/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.multitank.blocks;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.blockcommands.ListCommand;
import mcjty.lib.blockcommands.ServerCommand;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.rftoolscontrol.modules.multitank.MultiTankModule;
import mcjty.rftoolscontrol.modules.multitank.util.MultiTankFluidProperties;
import mcjty.rftoolscontrol.modules.multitank.util.MultiTankHandler;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;

public class MultiTankTileEntity
extends GenericTileEntity {
    public static final int TANKS = 4;
    public static final int MAXCAPACITY = 10000;
    private final MultiTankFluidProperties[] properties = new MultiTankFluidProperties[4];
    @Cap(type=CapType.FLUIDS)
    private final LazyOptional<MultiTankHandler> fluidHandler = LazyOptional.of(this::createFluidHandler);
    @Cap(type=CapType.CONTAINER)
    private final LazyOptional<INamedContainerProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Multi tank").containerSupplier(DefaultContainerProvider.empty(MultiTankModule.MULTITANK_CONTAINER, (GenericTileEntity)this)).setupSync((GenericTileEntity)this));
    @ServerCommand(type=FluidStack.class)
    public static final ListCommand<?, ?> CMD_GETFLUIDS = ListCommand.create((String)"rftoolscontrol.tank.getFluids", (te, player, params) -> {
        ArrayList<FluidStack> result = new ArrayList<FluidStack>(4);
        for (MultiTankFluidProperties property : te.properties) {
            result.add(property.getContents());
        }
        return result;
    }, (te, player, params, list) -> {
        for (int i = 0; i < 4; ++i) {
            te.properties[i].set((FluidStack)list.get(i));
        }
    });
    private MultiTankHandler handler = null;

    public MultiTankTileEntity() {
        super((TileEntityType)MultiTankModule.MULTITANK_TILE.get());
        for (int i = 0; i < 4; ++i) {
            this.properties[i] = new MultiTankFluidProperties(this, FluidStack.EMPTY, 10000);
        }
    }

    public MultiTankFluidProperties[] getProperties() {
        return this.properties;
    }

    protected void loadInfo(CompoundNBT tagCompound) {
        super.loadInfo(tagCompound);
        CompoundNBT info = tagCompound.func_74775_l("Info");
        for (int i = 0; i < 4; ++i) {
            this.properties[i] = new MultiTankFluidProperties(this, FluidStack.loadFluidStackFromNBT((CompoundNBT)info.func_74775_l("f" + i)), 10000);
        }
    }

    protected void saveInfo(CompoundNBT tagCompound) {
        super.saveInfo(tagCompound);
        CompoundNBT info = this.getOrCreateInfo(tagCompound);
        for (int i = 0; i < 4; ++i) {
            FluidStack contents = this.properties[i].getContents();
            if (contents.isEmpty()) continue;
            CompoundNBT tag = new CompoundNBT();
            contents.writeToNBT(tag);
            info.func_218657_a("f" + i, (INBT)tag);
        }
    }

    @Nonnull
    private MultiTankHandler createFluidHandler() {
        return new MultiTankHandler(this);
    }
}

