/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures;

import com.telepathicgrunt.repurposedstructures.modinit.RSStructures;
import com.telepathicgrunt.repurposedstructures.utils.GeneralUtils;
import com.telepathicgrunt.repurposedstructures.world.structures.AbstractBaseStructure;
import java.util.List;
import java.util.Random;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.jigsaw.JigsawManager;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.structure.AbstractVillagePiece;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.structure.VillageConfig;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class ShipwreckEndStructure
extends AbstractBaseStructure<NoFeatureConfig> {
    private final ResourceLocation START_POOL = new ResourceLocation("repurposed_structures", "shipwrecks/end");

    public ShipwreckEndStructure() {
        super(NoFeatureConfig.field_236558_a_);
        RSStructures.RS_STRUCTURE_START_PIECES.add(this.START_POOL);
    }

    public Structure.IStartFactory<NoFeatureConfig> func_214557_a() {
        return (x$0, x$1, x$2, x$3, x$4, x$5) -> new Start((Structure<NoFeatureConfig>)x$0, x$1, x$2, x$3, x$4, x$5);
    }

    protected boolean isFeatureChunk(ChunkGenerator chunkGenerator, BiomeProvider biomeSource, long seed, SharedSeedRandom chunkRandom, int chunkX, int chunkZ, Biome biome, ChunkPos chunkPos, NoFeatureConfig defaultFeatureConfig) {
        return ShipwreckEndStructure.getGenerationHeight(new ChunkPos(chunkX, chunkZ), chunkGenerator) >= Math.min(chunkGenerator.func_230355_e_(), 20);
    }

    private static int getGenerationHeight(ChunkPos chunkPos1, ChunkGenerator chunkGenerator) {
        int x = chunkPos1.field_77276_a * 16;
        int z = chunkPos1.field_77275_b * 16;
        int heightmap1 = chunkGenerator.func_222531_c(x + 5, z, Heightmap.Type.WORLD_SURFACE_WG);
        int heightmap2 = chunkGenerator.func_222531_c(x, z + 5, Heightmap.Type.WORLD_SURFACE_WG);
        int heightmap3 = chunkGenerator.func_222531_c(x - 5, z, Heightmap.Type.WORLD_SURFACE_WG);
        int heightmap4 = chunkGenerator.func_222531_c(x, z - 5, Heightmap.Type.WORLD_SURFACE_WG);
        return Math.min(Math.min(heightmap1, heightmap2), Math.min(heightmap3, heightmap4));
    }

    public class Start
    extends StructureStart<NoFeatureConfig> {
        public Start(Structure<NoFeatureConfig> structureIn, int chunkX, int chunkZ, MutableBoundingBox box, int referenceIn, long seedIn) {
            super(structureIn, chunkX, chunkZ, box, referenceIn, seedIn);
        }

        public void generatePieces(DynamicRegistries dynamicRegistryManager, ChunkGenerator chunkGenerator, TemplateManager structureManager, int chunkX, int chunkZ, Biome biome, NoFeatureConfig defaultFeatureConfig) {
            BlockPos blockpos = new BlockPos(chunkX * 16, 64, chunkZ * 16);
            JigsawManager.func_242837_a((DynamicRegistries)dynamicRegistryManager, (VillageConfig)new VillageConfig(() -> (JigsawPattern)dynamicRegistryManager.func_243612_b(Registry.field_243555_ax).func_82594_a(ShipwreckEndStructure.this.START_POOL), 1), AbstractVillagePiece::new, (ChunkGenerator)chunkGenerator, (TemplateManager)structureManager, (BlockPos)blockpos, (List)this.field_75075_a, (Random)this.field_214631_d, (boolean)true, (boolean)false);
            GeneralUtils.centerAllPieces(blockpos, this.field_75075_a);
            this.func_202500_a();
            BlockPos blockPos = new BlockPos(((StructurePiece)this.field_75075_a.get(0)).func_74874_b().func_215126_f());
            int highestLandPos = chunkGenerator.func_222529_a(blockPos.func_177958_n(), blockPos.func_177952_p(), Heightmap.Type.WORLD_SURFACE_WG);
            highestLandPos = Math.max(30, highestLandPos);
            this.func_214626_a((Random)this.field_214631_d, highestLandPos - 5, highestLandPos - 3);
        }
    }
}

