/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures;

import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import com.telepathicgrunt.repurposedstructures.misc.BiomeSourceChecks;
import com.telepathicgrunt.repurposedstructures.modinit.RSStructures;
import com.telepathicgrunt.repurposedstructures.world.structures.AbstractBaseStructure;
import com.telepathicgrunt.repurposedstructures.world.structures.pieces.PieceLimitedJigsawManager;
import java.util.Random;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.structure.MarginedStructureStart;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.VillageConfig;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.util.Lazy;

public class AdvancedJigsawStructure
extends AbstractBaseStructure<NoFeatureConfig> {
    protected final ResourceLocation startPool;
    protected final Lazy<Integer> structureSize;
    protected final int biomeRange;
    protected final Lazy<Integer> maxY;
    protected final Lazy<Integer> minY;
    protected final boolean clipOutOfBoundsPieces;
    protected final Lazy<Integer> verticalRange;

    public AdvancedJigsawStructure(ResourceLocation poolID, Lazy<Integer> structureSize, int biomeRange, Lazy<Integer> maxY, Lazy<Integer> minY, boolean clipOutOfBoundsPieces, Lazy<Integer> verticalRange) {
        super(NoFeatureConfig.field_236558_a_);
        this.startPool = poolID;
        this.structureSize = structureSize;
        this.biomeRange = biomeRange;
        this.maxY = maxY;
        this.minY = minY;
        this.clipOutOfBoundsPieces = clipOutOfBoundsPieces;
        this.verticalRange = verticalRange;
        RSStructures.RS_STRUCTURE_START_PIECES.add(this.startPool);
    }

    protected boolean isFeatureChunk(ChunkGenerator chunkGenerator, BiomeProvider biomeSource, long seed, SharedSeedRandom chunkRandom, int chunkX, int chunkZ, Biome biome, ChunkPos chunkPos, NoFeatureConfig defaultFeatureConfig) {
        if (!BiomeSourceChecks.isCheckeredBiomeSource(biomeSource) && !BiomeSourceChecks.isHexlandBiomeSource(biomeSource)) {
            for (int curChunkX = chunkX - this.biomeRange; curChunkX <= chunkX + this.biomeRange; ++curChunkX) {
                for (int curChunkZ = chunkZ - this.biomeRange; curChunkZ <= chunkZ + this.biomeRange; ++curChunkZ) {
                    if (biomeSource.func_225526_b_(curChunkX << 2, 64, curChunkZ << 2).func_242440_e().func_242493_a((Structure)this)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public Structure.IStartFactory<NoFeatureConfig> func_214557_a() {
        return (x$0, x$1, x$2, x$3, x$4, x$5) -> new MainStart((Structure<NoFeatureConfig>)x$0, x$1, x$2, x$3, x$4, x$5);
    }

    public static class Builder<T extends Builder<T>> {
        protected final ResourceLocation startPool;
        protected Lazy<Integer> structureSize = Lazy.of(() -> 1);
        protected int biomeRange = 0;
        protected Lazy<Integer> maxY = Lazy.of(() -> 255);
        protected Lazy<Integer> minY = Lazy.of(() -> 0);
        protected boolean clipOutOfBoundsPieces = true;
        protected Lazy<Integer> verticalRange = null;

        public Builder(ResourceLocation startPool) {
            this.startPool = startPool;
        }

        protected T getThis() {
            return (T)this;
        }

        public T setStructureSize(ForgeConfigSpec.IntValue structureSize) {
            this.structureSize = Lazy.of(() -> ((ForgeConfigSpec.IntValue)structureSize).get());
            return this.getThis();
        }

        public T setBiomeRange(int biomeRange) {
            this.biomeRange = biomeRange;
            return this.getThis();
        }

        public T setMaxY(ForgeConfigSpec.IntValue maxY) {
            this.maxY = Lazy.of(() -> ((ForgeConfigSpec.IntValue)maxY).get());
            return this.getThis();
        }

        public T setMinY(ForgeConfigSpec.IntValue minY) {
            this.minY = Lazy.of(() -> ((ForgeConfigSpec.IntValue)minY).get());
            return this.getThis();
        }

        public T setVerticalRange(ForgeConfigSpec.IntValue verticalRange) {
            this.verticalRange = Lazy.of(() -> ((ForgeConfigSpec.IntValue)verticalRange).get());
            return this.getThis();
        }

        public T doNotClipOutOfBoundsPieces() {
            this.clipOutOfBoundsPieces = false;
            return this.getThis();
        }

        public AdvancedJigsawStructure build() {
            return new AdvancedJigsawStructure(this.startPool, this.structureSize, this.biomeRange, this.maxY, this.minY, this.clipOutOfBoundsPieces, this.verticalRange);
        }
    }

    public class MainStart
    extends MarginedStructureStart<NoFeatureConfig> {
        private final ResourceLocation structureID;

        public MainStart(Structure<NoFeatureConfig> structureIn, int chunkX, int chunkZ, MutableBoundingBox box, int referenceIn, long seedIn) {
            super(structureIn, chunkX, chunkZ, box, referenceIn, seedIn);
            this.structureID = Registry.field_218361_B.func_177774_c(structureIn);
        }

        public void generatePieces(DynamicRegistries dynamicRegistryManager, ChunkGenerator chunkGenerator, TemplateManager structureManager, int chunkX, int chunkZ, Biome biome, NoFeatureConfig defaultFeatureConfig) {
            int bottomClipOff;
            int topClipOff;
            BlockPos.Mutable blockpos = new BlockPos.Mutable(chunkX * 16, 0, chunkZ * 16);
            if ((Integer)AdvancedJigsawStructure.this.maxY.get() - (Integer)AdvancedJigsawStructure.this.minY.get() <= 0) {
                RepurposedStructures.LOGGER.error("MinY should always be less than MaxY or else a crash will occur or no pieces will spawn. Problematic structure is:" + Registry.field_218361_B.func_177774_c((Object)this.func_214627_k()));
            }
            int structureStartHeight = this.field_214631_d.nextInt((Integer)AdvancedJigsawStructure.this.maxY.get() - (Integer)AdvancedJigsawStructure.this.minY.get()) + (Integer)AdvancedJigsawStructure.this.minY.get();
            blockpos.func_189534_c(Direction.UP, structureStartHeight);
            if (AdvancedJigsawStructure.this.verticalRange == null) {
                topClipOff = AdvancedJigsawStructure.this.clipOutOfBoundsPieces ? (Integer)AdvancedJigsawStructure.this.maxY.get() + 5 : Integer.MAX_VALUE;
                bottomClipOff = AdvancedJigsawStructure.this.clipOutOfBoundsPieces ? (Integer)AdvancedJigsawStructure.this.minY.get() - 5 : Integer.MIN_VALUE;
            } else {
                topClipOff = structureStartHeight + (Integer)AdvancedJigsawStructure.this.verticalRange.get();
                bottomClipOff = structureStartHeight - (Integer)AdvancedJigsawStructure.this.verticalRange.get();
            }
            PieceLimitedJigsawManager.assembleJigsawStructure(dynamicRegistryManager, new VillageConfig(() -> (JigsawPattern)dynamicRegistryManager.func_243612_b(Registry.field_243555_ax).func_82594_a(AdvancedJigsawStructure.this.startPool), ((Integer)AdvancedJigsawStructure.this.structureSize.get()).intValue()), chunkGenerator, structureManager, (BlockPos)blockpos, this.field_75075_a, (Random)this.field_214631_d, false, false, this.structureID, topClipOff, bottomClipOff);
            this.func_202500_a();
        }
    }
}

