/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.predicates;

import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.repurposedstructures.modinit.RSPredicates;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Util;
import net.minecraft.world.gen.feature.template.IRuleTestType;
import net.minecraft.world.gen.feature.template.RuleTest;

public class MatterPhaseRuleTest
extends RuleTest {
    public static final Codec<MatterPhaseRuleTest> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)IStringSerializable.func_233023_a_(MATTER_PHASE::values, MATTER_PHASE::byName).fieldOf("phase_to_test_for").stable().forGetter(ruletest -> ruletest.phaseToTestFor), (App)Codec.BOOL.fieldOf("invert_condition").forGetter(ruletest -> ruletest.invertCondition)).apply((Applicative)instance, instance.stable(MatterPhaseRuleTest::new)));
    private final MATTER_PHASE phaseToTestFor;
    private final boolean invertCondition;

    private MatterPhaseRuleTest(MATTER_PHASE phaseToTestFor, boolean invertCondition) {
        this.phaseToTestFor = phaseToTestFor;
        this.invertCondition = invertCondition;
    }

    public boolean func_215181_a(BlockState state, Random random) {
        boolean phaseMatch = false;
        switch (this.phaseToTestFor) {
            case AIR: {
                if (!state.func_196958_f()) break;
                phaseMatch = true;
                break;
            }
            case LIQUID: {
                if (state.func_204520_s().func_206888_e()) break;
                phaseMatch = true;
                break;
            }
            case SOLID: {
                if (state.func_196958_f() || !state.func_204520_s().func_206888_e() || !state.func_200132_m()) break;
                phaseMatch = true;
            }
        }
        if (this.invertCondition) {
            phaseMatch = !phaseMatch;
        }
        return phaseMatch;
    }

    protected IRuleTestType<?> func_215180_a() {
        return RSPredicates.MATTER_PHASE_RULE_TEST;
    }

    public static enum MATTER_PHASE implements IStringSerializable
    {
        SOLID("SOLID"),
        LIQUID("LIQUID"),
        AIR("AIR");

        private final String name;
        private static final Map<String, MATTER_PHASE> BY_NAME;

        private MATTER_PHASE(String name) {
            this.name = name;
        }

        public static MATTER_PHASE byName(String name) {
            return BY_NAME.get(name.toUpperCase(Locale.ROOT));
        }

        public String func_176610_l() {
            return this.name;
        }

        static {
            BY_NAME = (Map)Util.func_200696_a((Object)Maps.newHashMap(), hashMap -> {
                MATTER_PHASE[] var1;
                for (MATTER_PHASE type : var1 = MATTER_PHASE.values()) {
                    hashMap.put(type.name, type);
                }
            });
        }
    }
}

