/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.biomeinjection;

import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import com.telepathicgrunt.repurposedstructures.configs.RSDungeonsConfig;
import com.telepathicgrunt.repurposedstructures.modinit.RSConfiguredFeatures;
import com.telepathicgrunt.repurposedstructures.utils.BiomeSelection;
import java.util.function.Supplier;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Features;
import net.minecraftforge.event.world.BiomeLoadingEvent;

public final class Dungeons {
    private Dungeons() {
    }

    public static void addDungeons(BiomeLoadingEvent event) {
        if ((Integer)RSDungeonsConfig.jungleDungeonAttemptsPerChunk.get() != 0 && Dungeons.genericDungeonCheck(event, RSConfiguredFeatures.JUNGLE_DUNGEONS, () -> BiomeSelection.haveCategories(event, Biome.Category.JUNGLE))) {
            Dungeons.replaceOrAddDungeon(true, event, RSConfiguredFeatures.JUNGLE_DUNGEONS);
        }
        if ((Integer)RSDungeonsConfig.badlandsDungeonAttemptsPerChunk.get() != 0 && Dungeons.genericDungeonCheck(event, RSConfiguredFeatures.BADLANDS_DUNGEONS, () -> BiomeSelection.haveCategories(event, Biome.Category.MESA))) {
            Dungeons.replaceOrAddDungeon(true, event, RSConfiguredFeatures.BADLANDS_DUNGEONS);
        }
        if ((Integer)RSDungeonsConfig.darkForestDungeonAttemptsPerChunk.get() != 0 && Dungeons.genericDungeonCheck(event, RSConfiguredFeatures.DARK_FOREST_DUNGEONS, () -> BiomeSelection.haveCategories(event, Biome.Category.FOREST) && BiomeSelection.hasName(event, "dark", "spooky", "dead", "haunted"))) {
            Dungeons.replaceOrAddDungeon(true, event, RSConfiguredFeatures.DARK_FOREST_DUNGEONS);
        }
        if ((Integer)RSDungeonsConfig.desertDungeonAttemptsPerChunk.get() != 0 && Dungeons.genericDungeonCheck(event, RSConfiguredFeatures.DESERT_DUNGEONS, () -> BiomeSelection.haveCategories(event, Biome.Category.DESERT))) {
            Dungeons.replaceOrAddDungeon(true, event, RSConfiguredFeatures.DESERT_DUNGEONS);
        }
        if ((Integer)RSDungeonsConfig.mushroomDungeonAttemptsPerChunk.get() != 0) {
            if (BiomeSelection.isBiomeAllowed(event, RSConfiguredFeatures.MUSHROOM_HIGH_DUNGEONS, () -> BiomeSelection.haveCategories(event, Biome.Category.MUSHROOM) && (Integer)RSDungeonsConfig.mushroomDungeonMaxHeight.get() > 62)) {
                Dungeons.replaceOrAddDungeon(true, event, RSConfiguredFeatures.MUSHROOM_HIGH_DUNGEONS);
            }
            if (BiomeSelection.isBiomeAllowed(event, RSConfiguredFeatures.MUSHROOM_LOW_DUNGEONS, () -> BiomeSelection.haveCategories(event, Biome.Category.MUSHROOM) && (Integer)RSDungeonsConfig.mushroomDungeonMinHeight.get() <= 62)) {
                Dungeons.replaceOrAddDungeon(true, event, RSConfiguredFeatures.MUSHROOM_LOW_DUNGEONS);
            }
        }
        if ((Integer)RSDungeonsConfig.swampDungeonAttemptsPerChunk.get() != 0 && Dungeons.genericDungeonCheck(event, RSConfiguredFeatures.SWAMP_DUNGEONS, () -> BiomeSelection.haveCategories(event, Biome.Category.SWAMP))) {
            Dungeons.replaceOrAddDungeon(true, event, RSConfiguredFeatures.SWAMP_DUNGEONS);
        }
        if ((Integer)RSDungeonsConfig.icyDungeonAttemptsPerChunk.get() != 0 && Dungeons.genericDungeonCheck(event, RSConfiguredFeatures.ICY_DUNGEONS, () -> BiomeSelection.haveCategories(event, Biome.Category.ICY) && (BiomeSelection.hasName(event, "icy", "ice", "frozen") || event.getClimate().field_242461_c < 0.0f && !BiomeSelection.hasName(event, "snow")))) {
            Dungeons.replaceOrAddDungeon(true, event, RSConfiguredFeatures.ICY_DUNGEONS);
        }
        if ((Integer)RSDungeonsConfig.snowDungeonAttemptsPerChunk.get() != 0 && Dungeons.genericDungeonCheck(event, RSConfiguredFeatures.SNOW_DUNGEONS, () -> !(!BiomeSelection.haveCategories(event, Biome.Category.ICY) || BiomeSelection.hasName(event, "icy", "ice", "frozen") || event.getClimate().field_242461_c < 0.0f && !BiomeSelection.hasName(event, "snow")))) {
            Dungeons.replaceOrAddDungeon(true, event, RSConfiguredFeatures.SNOW_DUNGEONS);
        }
        if ((Integer)RSDungeonsConfig.netherDungeonAttemptsPerChunk.get() != 0 && Dungeons.genericDungeonCheck(event, RSConfiguredFeatures.NETHER_DUNGEONS, () -> BiomeSelection.haveCategories(event, Biome.Category.NETHER))) {
            event.getGeneration().getFeatures(GenerationStage.Decoration.VEGETAL_DECORATION).add(() -> RSConfiguredFeatures.NETHER_DUNGEONS);
        }
        if ((Integer)RSDungeonsConfig.endDungeonAttemptsPerChunk.get() != 0 && Dungeons.genericDungeonCheck(event, RSConfiguredFeatures.END_DUNGEONS, () -> BiomeSelection.haveCategories(event, Biome.Category.THEEND) && !BiomeSelection.isBiome(event, Biomes.field_76779_k, Biomes.field_201936_P))) {
            Dungeons.replaceOrAddDungeon(false, event, RSConfiguredFeatures.END_DUNGEONS);
        }
        if ((Integer)RSDungeonsConfig.oceanDungeonAttemptsPerChunk.get() != 0) {
            if (Dungeons.genericDungeonCheck(event, RSConfiguredFeatures.OCEAN_LUKEWARM_DUNGEONS, () -> BiomeSelection.haveCategories(event, Biome.Category.OCEAN) && (BiomeSelection.hasName(event, "lukewarm") || !BiomeSelection.hasNamespace(event, "minecraft") && event.getClimate().field_242461_c >= 0.9f && event.getClimate().field_242461_c < 1.5f))) {
                Dungeons.replaceOrAddDungeon(false, event, RSConfiguredFeatures.OCEAN_LUKEWARM_DUNGEONS);
            }
            if (Dungeons.genericDungeonCheck(event, RSConfiguredFeatures.OCEAN_WARM_DUNGEONS, () -> BiomeSelection.haveCategories(event, Biome.Category.OCEAN) && (BiomeSelection.hasName(event, "hot", "tropic", "warm") && !BiomeSelection.hasName(event, "lukewarm") || !BiomeSelection.hasNamespace(event, "minecraft") && event.getClimate().field_242461_c >= 1.5f))) {
                Dungeons.replaceOrAddDungeon(false, event, RSConfiguredFeatures.OCEAN_WARM_DUNGEONS);
            }
            if (Dungeons.genericDungeonCheck(event, RSConfiguredFeatures.OCEAN_COLD_DUNGEONS, () -> BiomeSelection.haveCategories(event, Biome.Category.OCEAN) && (BiomeSelection.hasName(event, "cold") || !BiomeSelection.hasNamespace(event, "minecraft") && event.getClimate().field_242461_c >= 0.0f && event.getClimate().field_242461_c < 0.5f))) {
                Dungeons.replaceOrAddDungeon(false, event, RSConfiguredFeatures.OCEAN_COLD_DUNGEONS);
            }
            if (Dungeons.genericDungeonCheck(event, RSConfiguredFeatures.OCEAN_FROZEN_DUNGEONS, () -> BiomeSelection.haveCategories(event, Biome.Category.OCEAN) && (BiomeSelection.hasName(event, "frozen", "snow", "ice") || !BiomeSelection.hasNamespace(event, "minecraft") && event.getClimate().field_242461_c >= 0.9f && event.getClimate().field_242461_c < 1.5f))) {
                Dungeons.replaceOrAddDungeon(false, event, RSConfiguredFeatures.OCEAN_FROZEN_DUNGEONS);
            }
            if (Dungeons.genericDungeonCheck(event, RSConfiguredFeatures.OCEAN_NEUTRAL_DUNGEONS, () -> BiomeSelection.haveCategories(event, Biome.Category.OCEAN) && (!BiomeSelection.hasName(event, "hot", "tropic", "warm", "cold", "frozen", "snow", "ice") || !BiomeSelection.hasNamespace(event, "minecraft") && event.getClimate().field_242461_c >= 0.5f && event.getClimate().field_242461_c < 0.9f))) {
                Dungeons.replaceOrAddDungeon(false, event, RSConfiguredFeatures.OCEAN_NEUTRAL_DUNGEONS);
            }
        }
    }

    private static boolean genericDungeonCheck(BiomeLoadingEvent context, ConfiguredFeature<?, ?> configuredFeature, Supplier<Boolean> condition) {
        return BiomeSelection.isBiomeAllowed(context, configuredFeature, () -> RSConfiguredFeatures.RS_DUNGEONS.stream().noneMatch(cf -> BiomeSelection.hasFeature(context, cf)) && (Boolean)condition.get() != false);
    }

    private static void replaceOrAddDungeon(boolean replacing, BiomeLoadingEvent event, ConfiguredFeature<?, ?> rsDungeon) {
        if (replacing && !RepurposedStructures.yungsBetterDungeonsIsOn) {
            event.getGeneration().getFeatures(GenerationStage.Decoration.UNDERGROUND_STRUCTURES).removeIf(supplier -> ((ConfiguredFeature)supplier.get()).field_222737_a.equals(Features.field_243797_W.field_222737_a));
        }
        event.getGeneration().getFeatures(GenerationStage.Decoration.UNDERGROUND_STRUCTURES).add(() -> rsDungeon);
    }
}

