/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures;

import com.google.common.collect.ImmutableMap;
import com.telepathicgrunt.repurposedstructures.biomeinjection.Bastions;
import com.telepathicgrunt.repurposedstructures.biomeinjection.Cities;
import com.telepathicgrunt.repurposedstructures.biomeinjection.Dungeons;
import com.telepathicgrunt.repurposedstructures.biomeinjection.Fortresses;
import com.telepathicgrunt.repurposedstructures.biomeinjection.Igloos;
import com.telepathicgrunt.repurposedstructures.biomeinjection.Mansions;
import com.telepathicgrunt.repurposedstructures.biomeinjection.Mineshafts;
import com.telepathicgrunt.repurposedstructures.biomeinjection.Outposts;
import com.telepathicgrunt.repurposedstructures.biomeinjection.Pyramids;
import com.telepathicgrunt.repurposedstructures.biomeinjection.RuinedPortals;
import com.telepathicgrunt.repurposedstructures.biomeinjection.Ruins;
import com.telepathicgrunt.repurposedstructures.biomeinjection.Shipwrecks;
import com.telepathicgrunt.repurposedstructures.biomeinjection.Strongholds;
import com.telepathicgrunt.repurposedstructures.biomeinjection.Temples;
import com.telepathicgrunt.repurposedstructures.biomeinjection.Villages;
import com.telepathicgrunt.repurposedstructures.biomeinjection.Wells;
import com.telepathicgrunt.repurposedstructures.biomeinjection.WitchHuts;
import com.telepathicgrunt.repurposedstructures.configs.RSBastionsConfig;
import com.telepathicgrunt.repurposedstructures.configs.RSBiomeDimConfig;
import com.telepathicgrunt.repurposedstructures.configs.RSCitiesConfig;
import com.telepathicgrunt.repurposedstructures.configs.RSDungeonsConfig;
import com.telepathicgrunt.repurposedstructures.configs.RSFortressesConfig;
import com.telepathicgrunt.repurposedstructures.configs.RSIgloosConfig;
import com.telepathicgrunt.repurposedstructures.configs.RSMansionsConfig;
import com.telepathicgrunt.repurposedstructures.configs.RSMineshaftsConfig;
import com.telepathicgrunt.repurposedstructures.configs.RSModdedLootConfig;
import com.telepathicgrunt.repurposedstructures.configs.RSNaturalMobSpawningConfig;
import com.telepathicgrunt.repurposedstructures.configs.RSOutpostsConfig;
import com.telepathicgrunt.repurposedstructures.configs.RSPyramidsConfig;
import com.telepathicgrunt.repurposedstructures.configs.RSRuinedPortalsConfig;
import com.telepathicgrunt.repurposedstructures.configs.RSRuinsConfig;
import com.telepathicgrunt.repurposedstructures.configs.RSShipwrecksConfig;
import com.telepathicgrunt.repurposedstructures.configs.RSStrongholdsConfig;
import com.telepathicgrunt.repurposedstructures.configs.RSTemplesConfig;
import com.telepathicgrunt.repurposedstructures.configs.RSVillagesConfig;
import com.telepathicgrunt.repurposedstructures.configs.RSWellsConfig;
import com.telepathicgrunt.repurposedstructures.configs.RSWitchHutsConfig;
import com.telepathicgrunt.repurposedstructures.configs.omegaconfig.OmegaConfig;
import com.telepathicgrunt.repurposedstructures.data.DataGenerators;
import com.telepathicgrunt.repurposedstructures.misc.BiomeDimensionAllowDisallow;
import com.telepathicgrunt.repurposedstructures.misc.BiomeSourceChecks;
import com.telepathicgrunt.repurposedstructures.misc.EndRemasteredDedicatedLoot;
import com.telepathicgrunt.repurposedstructures.misc.MobMapTrades;
import com.telepathicgrunt.repurposedstructures.misc.MobSpawnerManager;
import com.telepathicgrunt.repurposedstructures.misc.MobSpawningOverTime;
import com.telepathicgrunt.repurposedstructures.misc.NoiseSettingsDeepCopier;
import com.telepathicgrunt.repurposedstructures.misc.PoolAdditionMerger;
import com.telepathicgrunt.repurposedstructures.mixin.world.ChunkGeneratorAccessor;
import com.telepathicgrunt.repurposedstructures.modinit.RSConfiguredFeatures;
import com.telepathicgrunt.repurposedstructures.modinit.RSConfiguredStructures;
import com.telepathicgrunt.repurposedstructures.modinit.RSFeatures;
import com.telepathicgrunt.repurposedstructures.modinit.RSGlobalLootModifier;
import com.telepathicgrunt.repurposedstructures.modinit.RSNumberProviders;
import com.telepathicgrunt.repurposedstructures.modinit.RSPlacements;
import com.telepathicgrunt.repurposedstructures.modinit.RSPredicates;
import com.telepathicgrunt.repurposedstructures.modinit.RSProcessors;
import com.telepathicgrunt.repurposedstructures.modinit.RSStructureTagMap;
import com.telepathicgrunt.repurposedstructures.modinit.RSStructures;
import com.telepathicgrunt.repurposedstructures.utils.BiomeSelection;
import com.telepathicgrunt.repurposedstructures.utils.GeneralUtils;
import com.telepathicgrunt.repurposedstructures.utils.LogSpamFiltering;
import com.telepathicgrunt.repurposedstructures.world.structures.pieces.StructurePiecesBehavior;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.World;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.gen.FlatChunkGenerator;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.loading.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Logger;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;

@Mod(value="repurposed_structures")
public class RepurposedStructures {
    public static final org.apache.logging.log4j.Logger LOGGER = LogManager.getLogger();
    public static final String MODID = "repurposed_structures";
    public static final RSBiomeDimConfig RSOmegaBiomeDimConfig = OmegaConfig.register(RSBiomeDimConfig.class);
    public static final RSNaturalMobSpawningConfig RSNaturalMobSpawningConfig = OmegaConfig.register(RSNaturalMobSpawningConfig.class);
    public static MobSpawnerManager mobSpawnerManager = new MobSpawnerManager();
    public static boolean yungsBetterMineshaftIsOn = true;
    public static boolean yungsBetterDungeonsIsOn = true;
    public static boolean isCharmOn = false;
    public static boolean isCavesAndCliffsBackportOn = false;

    public RepurposedStructures() {
        ArtifactVersion modVersion;
        FileUtils.getOrCreateDirectory((Path)FMLPaths.CONFIGDIR.get().resolve("repurposed_structures-forge"), (String)"repurposed_structures-forge");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, RSModdedLootConfig.GENERAL_SPEC, "repurposed_structures-forge/modded_loot.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, RSDungeonsConfig.GENERAL_SPEC, "repurposed_structures-forge/dungeons.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, RSMineshaftsConfig.GENERAL_SPEC, "repurposed_structures-forge/mineshafts.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, RSStrongholdsConfig.GENERAL_SPEC, "repurposed_structures-forge/strongholds.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, RSWellsConfig.GENERAL_SPEC, "repurposed_structures-forge/wells.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, RSShipwrecksConfig.GENERAL_SPEC, "repurposed_structures-forge/shipwrecks.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, RSOutpostsConfig.GENERAL_SPEC, "repurposed_structures-forge/outposts.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, RSTemplesConfig.GENERAL_SPEC, "repurposed_structures-forge/temples.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, RSVillagesConfig.GENERAL_SPEC, "repurposed_structures-forge/villages.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, RSMansionsConfig.GENERAL_SPEC, "repurposed_structures-forge/mansions.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, RSWitchHutsConfig.GENERAL_SPEC, "repurposed_structures-forge/witch_huts.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, RSBastionsConfig.GENERAL_SPEC, "repurposed_structures-forge/bastions.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, RSCitiesConfig.GENERAL_SPEC, "repurposed_structures-forge/cities.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, RSFortressesConfig.GENERAL_SPEC, "repurposed_structures-forge/fortresses.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, RSIgloosConfig.GENERAL_SPEC, "repurposed_structures-forge/igloos.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, RSRuinedPortalsConfig.GENERAL_SPEC, "repurposed_structures-forge/ruined_portals.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, RSRuinsConfig.GENERAL_SPEC, "repurposed_structures-forge/ruins.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, RSPyramidsConfig.GENERAL_SPEC, "repurposed_structures-forge/pyramids.toml");
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        forgeBus.addListener(this::biomeModification);
        forgeBus.addListener(this::registerDatapackListener);
        forgeBus.addListener(EventPriority.HIGHEST, this::deepCopyDimensionalSpacing);
        forgeBus.addListener(this::addDimensionalSpacing);
        forgeBus.addListener(MobMapTrades::onVillagerTradesEvent);
        forgeBus.addListener(MobMapTrades::onWandererTradesEvent);
        forgeBus.addListener(PoolAdditionMerger::mergeAdditionPools);
        if (DataGenerators.datagenLootTableModeOn) {
            modEventBus.addListener(DataGenerators::gatherData);
        }
        modEventBus.addListener(this::setup);
        RSFeatures.FEATURES.register(modEventBus);
        RSStructures.STRUCTURE_FEATURES.register(modEventBus);
        RSPlacements.DECORATORS.register(modEventBus);
        RSGlobalLootModifier.GLM.register(modEventBus);
        yungsBetterMineshaftIsOn = ModList.get().isLoaded("bettermineshafts");
        yungsBetterDungeonsIsOn = ModList.get().isLoaded("betterdungeons");
        isCharmOn = ModList.get().isLoaded("charm");
        if (ModList.get().isLoaded("cavesandcliffs") && (modVersion = ((ModContainer)ModList.get().getModContainerById("cavesandcliffs").get()).getModInfo().getVersion()).compareTo((Object)new DefaultArtifactVersion("1.16.5-7.1.0")) > 0) {
            isCavesAndCliffsBackportOn = true;
        }
        EndRemasteredDedicatedLoot.isEndRemasteredOn = ModList.get().isLoaded("endrem");
        BiomeSourceChecks.hexlandsiiIsOn = ModList.get().isLoaded("hexlands");
        org.apache.logging.log4j.Logger rootLogger = LogManager.getRootLogger();
        if (rootLogger instanceof Logger) {
            ((Logger)rootLogger).addFilter((Filter)new LogSpamFiltering());
        } else {
            LOGGER.error("Registration failed with unexpected class: {}", rootLogger.getClass());
        }
    }

    public void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            StructurePiecesBehavior.init();
            RSProcessors.registerProcessors();
            RSPredicates.registerPredicates();
            RSNumberProviders.registerNumberProviders();
            RSConfiguredFeatures.registerConfiguredFeatures();
            RSStructures.setupStructures();
            RSConfiguredStructures.registerStructureFeatures();
            RSStructureTagMap.setupTags();
            RSGlobalLootModifier.registerLootData();
            BiomeSelection.setupOverworldBiomesSet();
            BiomeDimensionAllowDisallow.setupAllowDisallowMaps();
            MobSpawningOverTime.setupMobSpawningMaps();
            WorldGenRegistries.field_243658_j.func_239659_c_().forEach(settings -> {
                Map structureMap = ((DimensionSettings)settings.getValue()).func_236108_a_().func_236195_a_();
                if (structureMap instanceof ImmutableMap) {
                    HashMap tempMap = new HashMap(structureMap);
                    tempMap.putAll(RSStructures.RS_STRUCTURES);
                    ((DimensionSettings)settings.getValue()).func_236108_a_().field_236193_d_ = tempMap;
                } else {
                    structureMap.putAll(RSStructures.RS_STRUCTURES);
                }
            });
        });
    }

    public void registerDatapackListener(AddReloadListenerEvent event) {
        event.addListener((IFutureReloadListener)mobSpawnerManager);
    }

    public void biomeModification(BiomeLoadingEvent event) {
        RepurposedStructures.addFeaturesAndStructuresToBiomes(event);
    }

    public void deepCopyDimensionalSpacing(WorldEvent.Load event) {
        if (event.getWorld() instanceof ServerWorld) {
            ServerWorld serverWorld = (ServerWorld)event.getWorld();
            ResourceLocation cgRL = Registry.field_239690_aB_.func_177774_c(((ChunkGeneratorAccessor)serverWorld.func_72863_F().field_186029_c).repurposedstructures_getCodec());
            if (cgRL != null && cgRL.func_110624_b().equals("terraforged")) {
                return;
            }
            ChunkGenerator chunkGenerator = serverWorld.func_72863_F().field_186029_c;
            ((ChunkGeneratorAccessor)chunkGenerator).repurposedstructures_setSettings(NoiseSettingsDeepCopier.deepCopyDimensionStructuresSettings(chunkGenerator.func_235957_b_()));
        }
    }

    public void addDimensionalSpacing(WorldEvent.Load event) {
        if (event.getWorld() instanceof ServerWorld) {
            ServerWorld serverWorld = (ServerWorld)event.getWorld();
            ResourceLocation cgRL = Registry.field_239690_aB_.func_177774_c(((ChunkGeneratorAccessor)serverWorld.func_72863_F().field_186029_c).repurposedstructures_getCodec());
            if (cgRL != null && cgRL.func_110624_b().equals("terraforged")) {
                return;
            }
            HashMap tempMap = new HashMap(serverWorld.func_72863_F().func_201711_g().func_235957_b_().func_236195_a_());
            if (serverWorld.func_72863_F().func_201711_g() instanceof FlatChunkGenerator && serverWorld.func_234923_W_().equals(World.field_234918_g_)) {
                tempMap.keySet().removeAll(RSStructures.RS_STRUCTURES.keySet());
            } else {
                for (Map.Entry<Structure<?>, StructureSeparationSettings> structureFeatureEntry : RSStructures.RS_STRUCTURES.entrySet()) {
                    boolean isWorldBlacklisted = GeneralUtils.isBlacklistedForWorld((ISeedReader)serverWorld, Registry.field_218361_B.func_177774_c(structureFeatureEntry.getKey()));
                    if (isWorldBlacklisted) {
                        tempMap.remove(structureFeatureEntry.getKey());
                        continue;
                    }
                    tempMap.putIfAbsent(structureFeatureEntry.getKey(), structureFeatureEntry.getValue());
                }
            }
            serverWorld.func_72863_F().field_186029_c.func_235957_b_().field_236193_d_ = tempMap;
        }
    }

    public static void addFeaturesAndStructuresToBiomes(BiomeLoadingEvent event) {
        Mineshafts.addMineshafts(event);
        Dungeons.addDungeons(event);
        Wells.addWells(event);
        Strongholds.addStrongholds(event);
        Outposts.addOutposts(event);
        Shipwrecks.addShipwrecks(event);
        Fortresses.addJungleFortress(event);
        Temples.addTemples(event);
        Pyramids.addPyramids(event);
        Igloos.addIgloos(event);
        Villages.addVillages(event);
        RuinedPortals.addRuinedPortals(event);
        Ruins.addRuins(event);
        Cities.addCities(event);
        Mansions.addMansions(event);
        WitchHuts.addWitchHuts(event);
        Bastions.addBastions(event);
    }
}

