/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.numberproviders;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.telepathicgrunt.repurposedstructures.modinit.RSNumberProviders;
import java.lang.reflect.Type;
import java.util.Random;
import net.minecraft.loot.IRandomRange;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;

public class ProbabilityValue
implements IRandomRange {
    final float probability;
    final int resultCount;

    ProbabilityValue(float probability, int resultCount) {
        this.probability = probability;
        this.resultCount = resultCount;
    }

    public ResourceLocation func_215830_a() {
        return RSNumberProviders.PROBABILITY;
    }

    public int func_186511_a(Random random) {
        return random.nextFloat() <= this.probability ? this.resultCount : 0;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object != null && this.getClass() == object.getClass()) {
            return Float.compare(((ProbabilityValue)object).probability, this.probability) == 0 && ((ProbabilityValue)object).resultCount == this.resultCount;
        }
        return false;
    }

    public int hashCode() {
        return this.probability != 0.0f ? Float.floatToIntBits(this.probability) : 0;
    }

    public static class Serializer
    implements JsonDeserializer<ProbabilityValue>,
    JsonSerializer<ProbabilityValue> {
        public JsonElement serialize(ProbabilityValue probabilityValue, Type type, JsonSerializationContext jsonSerializationContext) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("probability", (Number)Float.valueOf(probabilityValue.probability));
            jsonObject.addProperty("result_count", (Number)probabilityValue.resultCount);
            return jsonObject;
        }

        public ProbabilityValue deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            JsonObject jsonobject = JSONUtils.func_151210_l((JsonElement)jsonElement, (String)"value");
            float probability = JSONUtils.func_151217_k((JsonObject)jsonobject, (String)"probability");
            int resultCount = JSONUtils.func_151203_m((JsonObject)jsonobject, (String)"result_count");
            return new ProbabilityValue(probability, resultCount);
        }
    }
}

