/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.utils;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Vector3i;

public class BoxOctree {
    private static final int subdivideThreshold = 10;
    private static final int maximumDepth = 3;
    private final AxisAlignedBB boundary;
    private final Vector3i size;
    private final int depth;
    private final List<AxisAlignedBB> innerBoxes = new ArrayList<AxisAlignedBB>();
    private final List<BoxOctree> childrenOctants = new ArrayList<BoxOctree>();

    public BoxOctree(AxisAlignedBB axisAlignedBB) {
        this(axisAlignedBB, 0);
    }

    private BoxOctree(AxisAlignedBB axisAlignedBB, int parentDepth) {
        this.boundary = axisAlignedBB.func_72317_d(0.0, 0.0, 0.0);
        this.size = new Vector3i(this.boundary.func_216364_b(), this.boundary.func_216360_c(), this.boundary.func_216362_d());
        this.depth = parentDepth + 1;
    }

    private void subdivide() {
        if (!this.childrenOctants.isEmpty()) {
            throw new UnsupportedOperationException("Repurposed Structures - Tried to subdivide when there are already children octants.");
        }
        int halfXSize = this.size.func_177958_n() / 2;
        int halfYSize = this.size.func_177956_o() / 2;
        int halfZSize = this.size.func_177952_p() / 2;
        this.childrenOctants.add(new BoxOctree(new AxisAlignedBB(this.boundary.field_72340_a, this.boundary.field_72338_b, this.boundary.field_72339_c, this.boundary.field_72340_a + (double)halfXSize, this.boundary.field_72338_b + (double)halfYSize, this.boundary.field_72339_c + (double)halfZSize), this.depth));
        this.childrenOctants.add(new BoxOctree(new AxisAlignedBB(this.boundary.field_72340_a + (double)halfXSize, this.boundary.field_72338_b, this.boundary.field_72339_c, this.boundary.field_72336_d, this.boundary.field_72338_b + (double)halfYSize, this.boundary.field_72339_c + (double)halfZSize), this.depth));
        this.childrenOctants.add(new BoxOctree(new AxisAlignedBB(this.boundary.field_72340_a, this.boundary.field_72338_b + (double)halfYSize, this.boundary.field_72339_c, this.boundary.field_72340_a + (double)halfXSize, this.boundary.field_72337_e, this.boundary.field_72339_c + (double)halfZSize), this.depth));
        this.childrenOctants.add(new BoxOctree(new AxisAlignedBB(this.boundary.field_72340_a, this.boundary.field_72338_b, this.boundary.field_72339_c + (double)halfZSize, this.boundary.field_72340_a + (double)halfXSize, this.boundary.field_72338_b + (double)halfYSize, this.boundary.field_72334_f), this.depth));
        this.childrenOctants.add(new BoxOctree(new AxisAlignedBB(this.boundary.field_72340_a + (double)halfXSize, this.boundary.field_72338_b + (double)halfYSize, this.boundary.field_72339_c, this.boundary.field_72336_d, this.boundary.field_72337_e, this.boundary.field_72339_c + (double)halfZSize), this.depth));
        this.childrenOctants.add(new BoxOctree(new AxisAlignedBB(this.boundary.field_72340_a, this.boundary.field_72338_b + (double)halfYSize, this.boundary.field_72339_c + (double)halfZSize, this.boundary.field_72340_a + (double)halfXSize, this.boundary.field_72337_e, this.boundary.field_72334_f), this.depth));
        this.childrenOctants.add(new BoxOctree(new AxisAlignedBB(this.boundary.field_72340_a + (double)halfXSize, this.boundary.field_72338_b, this.boundary.field_72339_c + (double)halfZSize, this.boundary.field_72336_d, this.boundary.field_72338_b + (double)halfYSize, this.boundary.field_72334_f), this.depth));
        this.childrenOctants.add(new BoxOctree(new AxisAlignedBB(this.boundary.field_72340_a + (double)halfXSize, this.boundary.field_72338_b + (double)halfYSize, this.boundary.field_72339_c + (double)halfZSize, this.boundary.field_72336_d, this.boundary.field_72337_e, this.boundary.field_72334_f), this.depth));
        for (AxisAlignedBB parentInnerBox : this.innerBoxes) {
            for (BoxOctree octree : this.childrenOctants) {
                if (!octree.boundaryContainsFuzzy(parentInnerBox)) continue;
                octree.addBox(parentInnerBox);
            }
        }
        this.innerBoxes.clear();
    }

    public void addBox(AxisAlignedBB axisAlignedBB) {
        if (this.depth < 3 && this.innerBoxes.size() > 10) {
            this.subdivide();
        }
        if (!this.childrenOctants.isEmpty()) {
            for (BoxOctree octree : this.childrenOctants) {
                if (!octree.boundaryContainsFuzzy(axisAlignedBB)) continue;
                octree.addBox(axisAlignedBB);
            }
        } else {
            for (AxisAlignedBB parentInnerBox : this.innerBoxes) {
                if (!parentInnerBox.equals((Object)axisAlignedBB)) continue;
                return;
            }
            this.innerBoxes.add(axisAlignedBB);
        }
    }

    public boolean boundaryContainsFuzzy(AxisAlignedBB axisAlignedBB) {
        return this.boundary.func_186662_g(axisAlignedBB.func_72320_b() / 2.0).func_72326_a(axisAlignedBB);
    }

    public boolean boundaryContains(AxisAlignedBB axisAlignedBB) {
        return this.boundary.func_197744_e(axisAlignedBB.field_72340_a, axisAlignedBB.field_72338_b, axisAlignedBB.field_72339_c) && this.boundary.func_197744_e(axisAlignedBB.field_72336_d, axisAlignedBB.field_72337_e, axisAlignedBB.field_72334_f);
    }

    public boolean intersectsAnyBox(AxisAlignedBB axisAlignedBB) {
        if (!this.childrenOctants.isEmpty()) {
            for (BoxOctree octree : this.childrenOctants) {
                if (!octree.intersectsAnyBox(axisAlignedBB)) continue;
                return true;
            }
        } else {
            for (AxisAlignedBB innerBox : this.innerBoxes) {
                if (!innerBox.func_72326_a(axisAlignedBB)) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return String.format("<%s | %s | %s | %s>", this.getClass().getSimpleName(), this.boundary.toString(), this.innerBoxes, this.childrenOctants);
    }
}

