/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.misc;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.reflect.TypeToken;
import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import com.telepathicgrunt.repurposedstructures.misc.MobSpawnerObj;
import com.telepathicgrunt.repurposedstructures.mixin.features.DungeonFeatureAccessor;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.resources.JsonReloadListener;
import net.minecraft.entity.EntityType;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.Level;

public class MobSpawnerManager
extends JsonReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private Map<ResourceLocation, List<MobSpawnerObj>> spawnerMap = ImmutableMap.of();

    public MobSpawnerManager() {
        super(GSON, "rs_spawners");
    }

    protected void apply(Map<ResourceLocation, JsonElement> loader, IResourceManager manager, IProfiler profiler) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        loader.forEach((fileResourceLocation, jsonElement) -> {
            try {
                List spawnerMobEntries = (List)GSON.fromJson(jsonElement.getAsJsonObject().get("mobs"), new TypeToken<List<MobSpawnerObj>>(){}.getType());
                for (int i = spawnerMobEntries.size() - 1; i >= 0; --i) {
                    MobSpawnerObj entry = (MobSpawnerObj)spawnerMobEntries.get(i);
                    entry.setEntityType();
                    if (entry.weight == 0) {
                        spawnerMobEntries.remove(i);
                        continue;
                    }
                    if (entry.weight >= 0) continue;
                    throw new Exception("Error: Found " + entry.name + " entry has a weight less than 0. Please remove the entry if you don't want a mob to be picked");
                }
                builder.put(fileResourceLocation, (Object)spawnerMobEntries);
            }
            catch (Exception e) {
                RepurposedStructures.LOGGER.error(" Couldn't parse spawner mob list {}", fileResourceLocation, (Object)e);
            }
        });
        this.spawnerMap = builder.build();
    }

    public EntityType<?> getSpawnerMob(ResourceLocation spawnerJsonEntry, Random random) {
        List<MobSpawnerObj> spawnerMobEntries = this.spawnerMap.get(spawnerJsonEntry);
        if (spawnerMobEntries == null) {
            RepurposedStructures.LOGGER.log(Level.ERROR, "\n***************************************\nFailed to get mob. Please check that " + spawnerJsonEntry + ".json is correct or that no other mod is interfering with how vanilla reads data folders. Let TelepathicGrunt know about this too!\n***************************************");
            return (EntityType)Util.func_240989_a_((Object[])DungeonFeatureAccessor.repurposedstructures_getMOB_SPAWNER_ENTITIES(), (Random)random);
        }
        int totalWeight = spawnerMobEntries.stream().mapToInt(mobEntry -> mobEntry.weight).sum();
        if (totalWeight == 0) {
            return null;
        }
        int randomWeight = random.nextInt(totalWeight) + 1;
        int index = 0;
        while ((randomWeight -= spawnerMobEntries.get((int)index).weight) > 0) {
            ++index;
        }
        return (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(spawnerMobEntries.get((int)index).name));
    }
}

