/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.util.potions;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectUtils;
import net.minecraft.potion.Effects;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import xreliquary.items.PotionEssenceItem;
import xreliquary.util.potions.EffectComparator;
import xreliquary.util.potions.PotionIngredient;
import xreliquary.util.potions.PotionMap;

public class XRPotionHelper {
    private static final String EFFECTS_TAG = "effects";
    private static final String EFFECTS_NBT_TAG = "effects";
    private static final int MAX_DURATION = 36000;
    private static final int MAX_AMPLIFIER = 4;
    private static final Effect[] nonAugmentableEffects = new Effect[]{Effects.field_76440_q, Effects.field_76431_k, Effects.field_76441_p, Effects.field_76439_r, Effects.field_76427_o};

    private XRPotionHelper() {
    }

    public static boolean isItemEssence(ItemStack stack) {
        return stack.func_77973_b() instanceof PotionEssenceItem;
    }

    public static boolean isIngredient(ItemStack stack) {
        for (PotionIngredient ingredient : PotionMap.ingredients) {
            if (!ingredient.getItem().func_77973_b().getRegistryName().equals((Object)stack.func_77973_b().getRegistryName())) continue;
            return true;
        }
        return false;
    }

    public static Optional<PotionIngredient> getIngredient(ItemStack stack) {
        if (stack.func_77973_b() instanceof PotionEssenceItem) {
            return Optional.of(new PotionIngredient(stack, XRPotionHelper.getPotionEffectsFromStack(stack)));
        }
        for (PotionIngredient ingredient : PotionMap.ingredients) {
            if (!ingredient.getItem().func_77973_b().getRegistryName().equals((Object)stack.func_77973_b().getRegistryName())) continue;
            return Optional.of(ingredient);
        }
        return Optional.empty();
    }

    private static boolean isAugmentablePotionEffect(EffectInstance effect) {
        for (Effect nonAugmentableEffect : nonAugmentableEffects) {
            if (nonAugmentableEffect != effect.func_188419_a()) continue;
            return false;
        }
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void addPotionTooltip(List<EffectInstance> effects, List<ITextComponent> list) {
        if (!effects.isEmpty()) {
            ArrayList list1 = Lists.newArrayList();
            for (EffectInstance potioneffect : effects) {
                String s1 = I18n.func_135052_a((String)potioneffect.func_76453_d(), (Object[])new Object[0]).trim();
                Effect potion = potioneffect.func_188419_a();
                Map map = potion.func_111186_k();
                if (!map.isEmpty()) {
                    for (Map.Entry entry : map.entrySet()) {
                        AttributeModifier attributemodifier = (AttributeModifier)entry.getValue();
                        AttributeModifier attributemodifier1 = new AttributeModifier(attributemodifier.func_111166_b(), potion.func_111183_a(potioneffect.func_76458_c(), attributemodifier), attributemodifier.func_220375_c());
                        list1.add(new Tuple((Object)((Attribute)entry.getKey()).func_233754_c_(), (Object)attributemodifier1));
                    }
                }
                if (potioneffect.func_76458_c() > 0) {
                    s1 = s1 + " " + I18n.func_135052_a((String)("potion.potency." + potioneffect.func_76458_c()), (Object[])new Object[0]).trim();
                }
                if (potioneffect.func_76459_b() > 20) {
                    s1 = s1 + " (" + EffectUtils.func_188410_a((EffectInstance)potioneffect, (float)1.0f) + ")";
                }
                if (potion.func_188408_i()) {
                    list.add((ITextComponent)new StringTextComponent(TextFormatting.BLUE.toString() + s1));
                    continue;
                }
                list.add((ITextComponent)new StringTextComponent(TextFormatting.RED.toString() + s1));
            }
            if (!list1.isEmpty()) {
                list.add((ITextComponent)new StringTextComponent(""));
                list.add((ITextComponent)new StringTextComponent(TextFormatting.DARK_PURPLE.toString() + I18n.func_135052_a((String)"potion.whenDrank", (Object[])new Object[0])));
                for (Tuple tuple : list1) {
                    AttributeModifier attributemodifier2 = (AttributeModifier)tuple.func_76340_b();
                    double d0 = attributemodifier2.func_111164_d();
                    double d1 = attributemodifier2.func_220375_c() != AttributeModifier.Operation.MULTIPLY_BASE && attributemodifier2.func_220375_c() != AttributeModifier.Operation.MULTIPLY_TOTAL ? attributemodifier2.func_111164_d() : attributemodifier2.func_111164_d() * 100.0;
                    if (d0 > 0.0) {
                        list.add((ITextComponent)new TranslationTextComponent("attribute.modifier.plus." + attributemodifier2.func_220375_c().func_220371_a(), new Object[]{ItemStack.field_111284_a.format(d1), new TranslationTextComponent((String)tuple.func_76341_a())}).func_240699_a_(TextFormatting.BLUE));
                        continue;
                    }
                    if (!(d0 < 0.0)) continue;
                    list.add((ITextComponent)new TranslationTextComponent("attribute.modifier.take." + attributemodifier2.func_220375_c().func_220371_a(), new Object[]{ItemStack.field_111284_a.format(d1 *= -1.0), new TranslationTextComponent((String)tuple.func_76341_a())}).func_240699_a_(TextFormatting.RED));
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void addPotionTooltip(ItemStack stack, List<ITextComponent> list) {
        XRPotionHelper.addPotionTooltip(XRPotionHelper.getPotionEffectsFromStack(stack), list);
    }

    public static void addPotionEffectsToCompoundTag(CompoundNBT tag, Collection<EffectInstance> effects) {
        if (effects.isEmpty()) {
            return;
        }
        ListNBT effectList = tag.func_150295_c("effects", 10);
        for (EffectInstance object : effects) {
            CompoundNBT effect = new CompoundNBT();
            effect.func_74778_a("name", object.func_188419_a().getRegistryName().toString());
            effect.func_74768_a("duration", object.func_188419_a().func_76403_b() ? 1 : object.func_76459_b());
            effect.func_74768_a("potency", object.func_76458_c());
            effectList.add((Object)effect);
        }
        tag.func_218657_a("effects", (INBT)effectList);
    }

    public static List<EffectInstance> getPotionEffectsFromCompoundTag(CompoundNBT tag) {
        if (!tag.func_74764_b("effects")) {
            return Lists.newArrayList();
        }
        ListNBT effectList = tag.func_150295_c("effects", 10);
        ArrayList ret = Lists.newArrayList();
        for (INBT effectTag : effectList) {
            CompoundNBT effect = (CompoundNBT)effectTag;
            String registryName = effect.func_74779_i("name");
            int duration = effect.func_74762_e("duration");
            int potency = effect.func_74762_e("potency");
            ret.add(new EffectInstance((Effect)ForgeRegistries.POTIONS.getValue(new ResourceLocation(registryName)), duration, potency));
        }
        return ret;
    }

    public static List<EffectInstance> getPotionEffectsFromStack(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return Collections.emptyList();
        }
        return XRPotionHelper.getPotionEffectsFromCompoundTag(stack.func_77978_p());
    }

    public static void addPotionEffectsToStack(ItemStack itemstack, List<EffectInstance> effects) {
        CompoundNBT tag = (CompoundNBT)MoreObjects.firstNonNull((Object)itemstack.func_77978_p(), (Object)new CompoundNBT());
        XRPotionHelper.addPotionEffectsToCompoundTag(tag, effects);
        itemstack.func_77982_d(tag);
    }

    public static void cleanPotionEffects(ItemStack stack) {
        CompoundNBT tag = stack.func_77978_p();
        if (tag == null) {
            return;
        }
        if (tag.func_74764_b("effects")) {
            tag.func_82580_o("effects");
        }
    }

    public static List<EffectInstance> changePotionEffectsDuration(Collection<EffectInstance> effects, float factor) {
        ArrayList ret = Lists.newArrayList();
        for (EffectInstance effect : effects) {
            int newDuration = (int)(effect.func_188419_a().func_76403_b() ? 1.0f : (float)effect.func_76459_b() * factor);
            ret.add(new EffectInstance(effect.func_188419_a(), newDuration, effect.func_76458_c(), effect.func_82720_e(), effect.func_188418_e()));
        }
        return ret;
    }

    public static List<EffectInstance> augmentPotionEffects(List<EffectInstance> effects, int redstoneCount, int glowstoneCount) {
        return XRPotionHelper.addRedstone(XRPotionHelper.addGlowstone(effects, glowstoneCount), redstoneCount);
    }

    private static List<EffectInstance> addRedstone(List<EffectInstance> effects, int redstoneCount) {
        if (redstoneCount <= 0) {
            return effects;
        }
        ArrayList<EffectInstance> newEffects = new ArrayList<EffectInstance>();
        int effectCnt = effects.size();
        double multiplier = 1.0;
        for (int redstoneLevel = 1; redstoneLevel <= redstoneCount; ++redstoneLevel) {
            multiplier *= (double)(8 + effectCnt) / (double)(3 + effectCnt) - 1.0 / (double)(3 + effectCnt) * ((double)redstoneLevel - 1.0);
        }
        for (EffectInstance effect : effects) {
            int newDuration = (int)((double)effect.func_76459_b() * multiplier);
            newDuration = Math.min(newDuration, 72000);
            EffectInstance newEffect = new EffectInstance(effect.func_188419_a(), newDuration, effect.func_76458_c(), effect.func_82720_e(), effect.func_188418_e());
            newEffects.add(newEffect);
        }
        return newEffects;
    }

    private static List<EffectInstance> addGlowstone(List<EffectInstance> effects, int glowstoneCount) {
        if (glowstoneCount <= 0) {
            return effects;
        }
        ArrayList<EffectInstance> newEffects = new ArrayList<EffectInstance>();
        int effectCnt = effects.size();
        double multiplier = 1.0;
        for (int glowstoneLevel = 1; glowstoneLevel <= glowstoneCount; ++glowstoneLevel) {
            multiplier *= (double)(11 + effectCnt) / (double)(6 + effectCnt) - 1.0 / (double)(6 + effectCnt) * (double)glowstoneLevel - 1.0;
        }
        for (EffectInstance effect : effects) {
            int newAmplifier = effect.func_76458_c();
            if (XRPotionHelper.isAugmentablePotionEffect(effect)) {
                newAmplifier = Math.min(effect.func_76458_c() + glowstoneCount, 5);
            }
            EffectInstance newEffect = new EffectInstance(effect.func_188419_a(), (int)((double)effect.func_76459_b() * multiplier), newAmplifier, effect.func_82720_e(), effect.func_188418_e());
            newEffects.add(newEffect);
        }
        return newEffects;
    }

    static List<EffectInstance> combineIngredients(PotionIngredient ... ingredients) {
        return XRPotionHelper.combineIngredients(Arrays.asList(ingredients));
    }

    public static List<EffectInstance> combineIngredients(Collection<PotionIngredient> ingredients) {
        HashMap potionEffectCounterList = new HashMap();
        ArrayList<ResourceLocation> potionEffectList = new ArrayList<ResourceLocation>();
        for (PotionIngredient ingredient : ingredients) {
            for (EffectInstance effect : ingredient.getEffects()) {
                if (potionEffectCounterList.containsKey(effect.func_188419_a().getRegistryName())) {
                    if (!potionEffectList.contains(effect.func_188419_a().getRegistryName())) {
                        potionEffectList.add(effect.func_188419_a().getRegistryName());
                    }
                    ((List)potionEffectCounterList.get(effect.func_188419_a().getRegistryName())).add(effect);
                    continue;
                }
                ArrayList<EffectInstance> effects = new ArrayList<EffectInstance>();
                effects.add(effect);
                potionEffectCounterList.put(effect.func_188419_a().getRegistryName(), effects);
            }
        }
        ArrayList combinedEffects = Lists.newArrayList();
        for (ResourceLocation potionName : potionEffectList) {
            Effect potion;
            List effects = (List)potionEffectCounterList.get(potionName);
            int duration = XRPotionHelper.getCombinedDuration(effects);
            int amplifier = XRPotionHelper.getCombinedAmplifier(effects);
            if (duration == 0 || (potion = (Effect)ForgeRegistries.POTIONS.getValue(potionName)) == null) continue;
            combinedEffects.add(new EffectInstance(potion, duration, amplifier));
        }
        combinedEffects.sort(new EffectComparator());
        return combinedEffects;
    }

    private static int getCombinedAmplifier(List<EffectInstance> effects) {
        int amplifier = 0;
        for (EffectInstance effect : effects) {
            amplifier += effect.func_76458_c();
        }
        return Math.min(amplifier, 4);
    }

    private static int getCombinedDuration(List<EffectInstance> effects) {
        int count = 0;
        int duration = 0;
        for (EffectInstance effect : effects) {
            if (effect.func_188419_a().func_76403_b()) {
                return 1;
            }
            ++count;
            duration += effect.func_76459_b();
        }
        duration = (int)((double)duration / 1.2);
        if (count == 3) {
            duration = (int)((double)duration / 1.1);
        }
        return Math.min(duration, 36000);
    }

    public static void applyEffectsToEntity(Collection<EffectInstance> effects, Entity source, @Nullable Entity indirectSource, LivingEntity entitylivingbase) {
        XRPotionHelper.applyEffectsToEntity(effects, source, indirectSource, entitylivingbase, 1.0);
    }

    public static void applyEffectsToEntity(Collection<EffectInstance> effects, Entity source, @Nullable Entity indirectSource, LivingEntity entitylivingbase, double amplifier) {
        for (EffectInstance potioneffect : effects) {
            if (potioneffect.func_188419_a().func_76403_b()) {
                potioneffect.func_188419_a().func_180793_a(source, indirectSource, entitylivingbase, potioneffect.func_76458_c(), amplifier);
                continue;
            }
            int j = (int)(amplifier * (double)potioneffect.func_76459_b() + 0.5);
            if (j <= 20) continue;
            entitylivingbase.func_195064_c(new EffectInstance(potioneffect.func_188419_a(), j, potioneffect.func_76458_c(), false, false));
        }
    }
}

