/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.pedestal.wrappers;

import java.util.ArrayDeque;
import java.util.List;
import java.util.Queue;
import net.minecraft.block.BeehiveBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.Property;
import net.minecraft.tileentity.BeehiveTileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.IForgeShearable;
import net.minecraftforge.common.util.FakePlayer;
import xreliquary.api.IPedestal;
import xreliquary.api.IPedestalActionItemWrapper;
import xreliquary.reference.Settings;

public class PedestalShearsWrapper
implements IPedestalActionItemWrapper {
    private boolean isShearingBlock = false;
    private BlockPos blockPosBeingSheared;
    private final Queue<BlockPos> blockQueue = new ArrayDeque<BlockPos>();

    @Override
    public void update(ItemStack stack, IPedestal pedestal) {
        int shearsRange;
        World world = pedestal.getTheWorld();
        BlockPos pos = pedestal.getBlockPos();
        FakePlayer fakePlayer = pedestal.getFakePlayer();
        if (!this.shearAnimals(stack, world, fakePlayer, pos, shearsRange = ((Integer)Settings.COMMON.blocks.pedestal.shearsWrapperRange.get()).intValue()) && !this.shearBlocks(stack, world, pedestal, fakePlayer, pos, shearsRange)) {
            pedestal.setActionCoolDown(100);
            return;
        }
        if (!this.isShearingBlock) {
            pedestal.setActionCoolDown((Integer)Settings.COMMON.blocks.pedestal.shearsWrapperCooldown.get());
        }
        if (stack.func_190916_E() == 0) {
            pedestal.destroyItem();
        }
    }

    @Override
    public void onRemoved(ItemStack stack, IPedestal pedestal) {
    }

    @Override
    public void stop(ItemStack stack, IPedestal pedestal) {
    }

    private boolean shearBlocks(ItemStack stack, World world, IPedestal pedestal, FakePlayer fakePlayer, BlockPos pos, int shearsRange) {
        if (!this.isShearingBlock) {
            if (this.blockQueue.isEmpty()) {
                this.updateQueue(stack, world, pos, shearsRange);
                if (this.blockQueue.isEmpty()) {
                    return false;
                }
            }
            this.blockPosBeingSheared = this.blockQueue.remove();
            BlockState blockState = world.func_180495_p(this.blockPosBeingSheared);
            if (this.isShearableBlock(stack, world, blockState)) {
                float hardness = blockState.func_185887_b((IBlockReader)world, this.blockPosBeingSheared);
                float digSpeed = stack.func_77973_b().func_150893_a(stack, blockState);
                pedestal.setActionCoolDown((int)(hardness * 1.5f * 20.0f / digSpeed));
                this.isShearingBlock = true;
            }
        } else {
            stack.func_77973_b().onBlockStartBreak(stack, this.blockPosBeingSheared, (PlayerEntity)fakePlayer);
            BlockState blockState = world.func_180495_p(this.blockPosBeingSheared);
            if (blockState.func_177230_c() instanceof BeehiveBlock) {
                this.shearBeehive(world, this.blockPosBeingSheared, blockState, stack);
            } else if (world.func_217377_a(this.blockPosBeingSheared, false)) {
                Block.func_220054_a((BlockState)blockState, (World)world, (BlockPos)pos, null, (Entity)fakePlayer, (ItemStack)new ItemStack((IItemProvider)Items.field_151097_aZ));
                world.func_217379_c(2001, this.blockPosBeingSheared, Block.func_196246_j((BlockState)blockState));
                stack.func_96631_a(1, world.func_201674_k(), null);
            }
            this.isShearingBlock = false;
        }
        return true;
    }

    private boolean isShearableBlock(ItemStack stack, World world, BlockState blockState) {
        Block block = blockState.func_177230_c();
        return block instanceof IForgeShearable && ((IForgeShearable)block).isShearable(stack, world, this.blockPosBeingSheared) || block instanceof BeehiveBlock && (Integer)blockState.func_177229_b((Property)BeehiveBlock.field_226873_c_) >= 5;
    }

    private void shearBeehive(World world, BlockPos pos, BlockState blockState, ItemStack stack) {
        int honeyLevel = (Integer)blockState.func_177229_b((Property)BeehiveBlock.field_226873_c_);
        if (honeyLevel >= 5) {
            world.func_184133_a(null, pos, SoundEvents.field_226133_ah_, SoundCategory.BLOCKS, 1.0f, 1.0f);
            BeehiveBlock.func_226878_a_((World)world, (BlockPos)pos);
            ((BeehiveBlock)blockState.func_177230_c()).func_226877_a_(world, blockState, pos, null, BeehiveTileEntity.State.BEE_RELEASED);
            stack.func_96631_a(1, world.func_201674_k(), null);
        }
    }

    private void updateQueue(ItemStack stack, World world, BlockPos pos, int shearsRange) {
        for (int y = pos.func_177956_o() - shearsRange; y <= pos.func_177956_o() + shearsRange; ++y) {
            for (int x = pos.func_177958_n() - shearsRange; x <= pos.func_177958_n() + shearsRange; ++x) {
                for (int z = pos.func_177952_p() - shearsRange; z <= pos.func_177952_p() + shearsRange; ++z) {
                    BlockPos currentBlockPos = new BlockPos(x, y, z);
                    BlockState blockState = world.func_180495_p(currentBlockPos);
                    if (!this.isShearableBlock(stack, world, blockState)) continue;
                    this.blockQueue.add(currentBlockPos);
                }
            }
        }
    }

    private boolean shearAnimals(ItemStack stack, World world, FakePlayer fakePlayer, BlockPos pos, int shearsRange) {
        List entities = world.func_217357_a(AnimalEntity.class, new AxisAlignedBB(pos.func_177982_a(-shearsRange, -shearsRange, -shearsRange), pos.func_177982_a(shearsRange, shearsRange, shearsRange)));
        for (AnimalEntity animal : entities) {
            if (!(animal instanceof IForgeShearable) || !((IForgeShearable)animal).isShearable(stack, world, animal.func_233580_cy_())) continue;
            fakePlayer.func_184611_a(Hand.MAIN_HAND, stack);
            fakePlayer.func_190775_a((Entity)animal, Hand.MAIN_HAND);
            return true;
        }
        return false;
    }
}

