/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import xreliquary.items.ToggleableItem;
import xreliquary.reference.Settings;
import xreliquary.util.InventoryHelper;
import xreliquary.util.LanguageHelper;
import xreliquary.util.NBTHelper;
import xreliquary.util.RegistryHelper;

public class InfernalTearItem
extends ToggleableItem {
    private static final String ENABLED_TAG = "enabled";
    private static final int COOLDOWN = 4;
    private static final int NOTHING_FOUND_COOLDOWN = 20;

    public InfernalTearItem() {
        super(new Item.Properties().func_200917_a(1).setNoRepair());
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (world.field_72995_K || world.func_82737_E() % 4L != 0L || !this.isEnabled(stack) || this.isInCooldown(stack, world) || !(entity instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)entity;
        ItemStack tearStack = InfernalTearItem.getStackFromTear(stack);
        if (tearStack.func_190926_b()) {
            this.resetTear(stack);
            return;
        }
        Optional<Integer> experience = Settings.COMMON.items.infernalTear.getItemExperience(RegistryHelper.getItemRegistryName(tearStack.func_77973_b()));
        if (!experience.isPresent()) {
            this.resetTear(stack);
            return;
        }
        int countConsumed = InventoryHelper.consumeItemStack(ist -> ItemHandlerHelper.canItemStacksStack((ItemStack)tearStack, (ItemStack)ist), player, 4).func_190916_E();
        if (countConsumed > 0) {
            player.func_195068_e(experience.get() * countConsumed);
        } else {
            this.setCooldown(stack, world, 20);
        }
    }

    private void resetTear(ItemStack stack) {
        CompoundNBT tag = stack.func_77978_p();
        if (tag != null) {
            tag.func_82580_o("item");
            tag.func_82580_o(ENABLED_TAG);
        }
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        if (InfernalTearItem.getStackFromTear(stack).func_190926_b()) {
            LanguageHelper.formatTooltip("tooltip.xreliquary.tear_empty", null, tooltip);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void addMoreInformation(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip) {
        ItemStack contents = InfernalTearItem.getStackFromTear(stack);
        String itemName = contents.func_200301_q().getString();
        LanguageHelper.formatTooltip("tooltip.xreliquary.tear", (ImmutableMap<String, String>)ImmutableMap.of((Object)"item", (Object)itemName), tooltip);
        if (this.isEnabled(stack)) {
            LanguageHelper.formatTooltip("tooltip.xreliquary.absorb_active", (ImmutableMap<String, String>)ImmutableMap.of((Object)"item", (Object)(TextFormatting.YELLOW + itemName)), tooltip);
        }
        tooltip.add((ITextComponent)new StringTextComponent(LanguageHelper.getLocalization("tooltip.xreliquary.absorb", new Object[0])));
        tooltip.add((ITextComponent)new StringTextComponent(LanguageHelper.getLocalization("tooltip.xreliquary.infernal_tear.absorb_unset", new Object[0])));
    }

    @Override
    protected boolean hasMoreInformation(ItemStack stack) {
        return !InfernalTearItem.getStackFromTear(stack).func_190926_b();
    }

    public static ItemStack getStackFromTear(ItemStack tear) {
        CompoundNBT itemNBT = NBTHelper.getTagCompound("item", tear);
        if (itemNBT.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        return ItemStack.func_199557_a((CompoundNBT)itemNBT);
    }

    public Rarity func_77613_e(ItemStack stack) {
        return Rarity.EPIC;
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack returnStack;
        ItemStack stack = player.func_184586_b(hand);
        ActionResult<ItemStack> actionResult = super.func_77659_a(world, player, hand);
        if (player.func_225608_bj_() && !this.isEnabled(stack)) {
            return actionResult;
        }
        ItemStack itemStack = (ItemStack)actionResult.func_188398_b();
        CompoundNBT nbt = itemStack.func_77978_p();
        if (!player.func_225608_bj_() && !InfernalTearItem.getStackFromTear(itemStack).func_190926_b()) {
            NBTHelper.remove(nbt, "item");
            NBTHelper.remove(nbt, ENABLED_TAG);
            return actionResult;
        }
        if (!InfernalTearItem.getStackFromTear(itemStack).func_190926_b()) {
            return actionResult;
        }
        if (!(!player.func_225608_bj_() && this.isEnabled(itemStack) || (returnStack = InventoryHelper.getItemHandlerFrom(player).map(handler -> this.buildTear(itemStack, (IItemHandler)handler)).orElse(ItemStack.field_190927_a)).func_190926_b())) {
            return new ActionResult(ActionResultType.SUCCESS, (Object)returnStack);
        }
        if (this.isEnabled(itemStack)) {
            this.toggleEnabled(itemStack);
        }
        return actionResult;
    }

    private ItemStack buildTear(ItemStack stack, IItemHandler inventory) {
        ItemStack tear = new ItemStack((IItemProvider)this, 1);
        ItemStack target = this.getTargetAlkahestItem(stack, inventory);
        if (target.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        InfernalTearItem.setTearTarget(tear, target);
        if (Boolean.TRUE.equals(Settings.COMMON.items.infernalTear.absorbWhenCreated.get())) {
            NBTHelper.putBoolean(ENABLED_TAG, stack, true);
        }
        return tear;
    }

    public static void setTearTarget(ItemStack tear, ItemStack target) {
        NBTHelper.putTagCompound("item", tear, target.func_77955_b(new CompoundNBT()));
    }

    private ItemStack getTargetAlkahestItem(ItemStack self, IItemHandler inventory) {
        ItemStack targetItem = ItemStack.field_190927_a;
        int itemQuantity = 0;
        for (int slot = 0; slot < inventory.getSlots(); ++slot) {
            ItemStack stack = inventory.getStackInSlot(slot);
            if (stack.func_190926_b() || self.func_77969_a(stack) || stack.func_77976_d() == 1 || stack.func_77978_p() != null || !Settings.COMMON.items.infernalTear.getItemExperience(RegistryHelper.getItemRegistryName(stack.func_77973_b())).isPresent() || InventoryHelper.getItemQuantity(stack, inventory) <= itemQuantity) continue;
            itemQuantity = InventoryHelper.getItemQuantity(stack, inventory);
            targetItem = stack.func_77946_l();
        }
        return targetItem;
    }
}

