/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.Rarity;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import xreliquary.entities.SpecialSnowballEntity;
import xreliquary.items.GlacialStaffItem;
import xreliquary.items.ToggleableItem;
import xreliquary.reference.Settings;
import xreliquary.util.LanguageHelper;
import xreliquary.util.NBTHelper;

public class IceMagusRodItem
extends ToggleableItem {
    public static final RedstoneParticleData ICE_PARTICLE = new RedstoneParticleData(0.3882353f, 0.76862746f, 0.99215686f, 1.0f);
    private static final String SNOWBALLS_TAG = "snowballs";

    public IceMagusRodItem() {
        super(new Item.Properties().func_200917_a(1).setNoRepair());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void addMoreInformation(ItemStack rod, @Nullable World world, List<ITextComponent> tooltip) {
        LanguageHelper.formatTooltip(this.func_77658_a() + ".tooltip2", (ImmutableMap<String, String>)ImmutableMap.of((Object)"charge", (Object)Integer.toString(NBTHelper.getInt(SNOWBALLS_TAG, rod))), tooltip);
        if (this.isEnabled(rod)) {
            LanguageHelper.formatTooltip("tooltip.absorb_active", (ImmutableMap<String, String>)ImmutableMap.of((Object)"item", (Object)(TextFormatting.BLUE + Items.field_151126_ay.func_200295_i(new ItemStack((IItemProvider)Items.field_151126_ay)).toString())), tooltip);
        }
        LanguageHelper.formatTooltip("tooltip.absorb", null, tooltip);
    }

    @Override
    protected boolean hasMoreInformation(ItemStack stack) {
        return true;
    }

    private int getSnowballCap() {
        return this instanceof GlacialStaffItem ? (Integer)Settings.COMMON.items.glacialStaff.snowballLimit.get() : (Integer)Settings.COMMON.items.iceMagusRod.snowballLimit.get();
    }

    int getSnowballCost() {
        return this instanceof GlacialStaffItem ? (Integer)Settings.COMMON.items.glacialStaff.snowballCost.get() : (Integer)Settings.COMMON.items.iceMagusRod.snowballCost.get();
    }

    private int getSnowballWorth() {
        return this instanceof GlacialStaffItem ? (Integer)Settings.COMMON.items.glacialStaff.snowballWorth.get() : (Integer)Settings.COMMON.items.iceMagusRod.snowballWorth.get();
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.field_82175_bq) {
            return new ActionResult(ActionResultType.PASS, (Object)stack);
        }
        player.func_184609_a(hand);
        if (!player.func_225608_bj_() && (NBTHelper.getInt(SNOWBALLS_TAG, stack) >= this.getSnowballCost() || player.func_184812_l_())) {
            world.func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_187737_v, SoundCategory.NEUTRAL, 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
            SpecialSnowballEntity snowball = new SpecialSnowballEntity(world, (LivingEntity)player, this instanceof GlacialStaffItem);
            snowball.func_234612_a_((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, 2.4f, 1.0f);
            world.func_217376_c((Entity)snowball);
            if (!player.func_184812_l_()) {
                NBTHelper.putInt(SNOWBALLS_TAG, stack, NBTHelper.getInt(SNOWBALLS_TAG, stack) - this.getSnowballCost());
            }
        }
        return super.func_77659_a(world, player, hand);
    }

    public Rarity func_77613_e(ItemStack stack) {
        return Rarity.EPIC;
    }

    public void func_77663_a(ItemStack rod, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (world.field_72995_K || world.func_82737_E() % 10L != 0L || !(entity instanceof PlayerEntity)) {
            return;
        }
        if (this.isEnabled(rod)) {
            int snowCharge = NBTHelper.getInt(SNOWBALLS_TAG, rod);
            this.consumeAndCharge((PlayerEntity)entity, this.getSnowballCap() - snowCharge, this.getSnowballWorth(), Items.field_151126_ay, 16, (int chargeToAdd) -> NBTHelper.putInt(SNOWBALLS_TAG, rod, snowCharge + chargeToAdd));
        }
    }
}

