/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.IItemHandler;
import xreliquary.api.IPedestal;
import xreliquary.api.IPedestalActionItem;
import xreliquary.items.ToggleableItem;
import xreliquary.items.util.fluid.FluidHandlerHeroMedallion;
import xreliquary.reference.Settings;
import xreliquary.util.InventoryHelper;
import xreliquary.util.LanguageHelper;
import xreliquary.util.NBTHelper;
import xreliquary.util.XpHelper;

public class HeroMedallionItem
extends ToggleableItem
implements IPedestalActionItem {
    private static final String EXPERIENCE_TAG = "experience";

    public HeroMedallionItem() {
        super(new Item.Properties().func_200918_c(0).setNoRepair());
    }

    public Rarity func_77613_e(ItemStack stack) {
        return Rarity.EPIC;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return NBTHelper.getBoolean("enabled", stack);
    }

    public int func_77626_a(ItemStack stack) {
        return 500;
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BLOCK;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void addMoreInformation(ItemStack medallion, @Nullable World world, List<ITextComponent> tooltip) {
        int experience = NBTHelper.getInt(EXPERIENCE_TAG, medallion);
        int levels = XpHelper.getLevelForExperience(experience);
        int remainingExperience = experience - XpHelper.getExperienceForLevel(levels);
        LanguageHelper.formatTooltip(this.func_77658_a() + ".tooltip2", (ImmutableMap<String, String>)ImmutableMap.of((Object)"levels", (Object)String.valueOf(levels), (Object)EXPERIENCE_TAG, (Object)String.valueOf(remainingExperience)), tooltip);
        if (this.isEnabled(medallion)) {
            LanguageHelper.formatTooltip("tooltip.absorb_active", (ImmutableMap<String, String>)ImmutableMap.of((Object)"item", (Object)(TextFormatting.GREEN + "XP")), tooltip);
        }
        LanguageHelper.formatTooltip("tooltip.absorb", null, tooltip);
    }

    @Override
    protected boolean hasMoreInformation(ItemStack stack) {
        return true;
    }

    private int getExperienceMinimum() {
        return (Integer)Settings.COMMON.items.heroMedallion.experienceLevelMinimum.get();
    }

    private int getExperienceMaximum() {
        return (Integer)Settings.COMMON.items.heroMedallion.experienceLevelMaximum.get();
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        PlayerEntity player;
        if (world.field_72995_K || !this.isEnabled(stack) || world.func_82737_E() % 10L != 0L) {
            return;
        }
        if (entity instanceof PlayerEntity && (!(player = (PlayerEntity)entity).func_184587_cr() || player.func_184607_cu() != stack)) {
            this.drainExperienceLevels(stack, player, 1);
        }
    }

    private void drainExperienceLevels(ItemStack stack, PlayerEntity player, int levelsToDrain) {
        int experiencePoints;
        int n = experiencePoints = player.func_184812_l_() ? 100 : player.field_71067_cb - XpHelper.getExperienceForLevel(Math.max(this.getExperienceMinimum(), player.field_71068_ca - levelsToDrain));
        if (experiencePoints > 0) {
            if (!player.func_184812_l_()) {
                this.decreasePlayerExperience(player, experiencePoints);
            }
            this.increaseMedallionExperience(stack, experiencePoints);
        }
    }

    private void decreasePlayerExperience(PlayerEntity player, int pointsToRemove) {
        int newLevel;
        player.field_71067_cb -= pointsToRemove;
        player.field_71068_ca = newLevel = XpHelper.getLevelForExperience(player.field_71067_cb);
        player.field_71106_cc = (float)(player.field_71067_cb - XpHelper.getExperienceForLevel(newLevel)) / (float)player.func_71050_bK();
    }

    private void decreaseMedallionExperience(ItemStack stack, int experience) {
        this.setExperience(stack, this.getExperience(stack) - experience);
    }

    private void increasePlayerExperience(PlayerEntity player, int xpPoints) {
        player.func_195068_e(xpPoints);
    }

    private void increaseMedallionExperience(ItemStack stack, int xpPoints) {
        this.setExperience(stack, this.getExperience(stack) + xpPoints);
    }

    public int getExperience(ItemStack stack) {
        return NBTHelper.getInt(EXPERIENCE_TAG, stack);
    }

    public void setExperience(ItemStack stack, int i) {
        NBTHelper.putInt(EXPERIENCE_TAG, stack, i);
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (world.field_72995_K) {
            return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
        }
        if (player.func_225608_bj_()) {
            return super.func_77659_a(world, player, hand);
        }
        player.func_184598_c(hand);
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    public void onUsingTick(ItemStack stack, LivingEntity entity, int count) {
        int cooldown;
        int n = cooldown = count > 20 ? 10 : 20;
        if (entity.field_70170_p.field_72995_K || !(entity instanceof PlayerEntity) || entity.field_70170_p.func_82737_E() % (long)cooldown != 0L) {
            return;
        }
        PlayerEntity player = (PlayerEntity)entity;
        World world = player.field_70170_p;
        if (this.isEnabled(stack)) {
            this.drainExperienceLevels(stack, player, 10);
            return;
        }
        this.increaseExperience(stack, player, world, 10);
    }

    private void increaseExperience(ItemStack stack, PlayerEntity player, World world, int levels) {
        BlockRayTraceResult rayTraceResult = HeroMedallionItem.func_219968_a((World)world, (PlayerEntity)player, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.ANY);
        if (rayTraceResult.func_216346_c() == RayTraceResult.Type.BLOCK) {
            BlockPos hitPos = rayTraceResult.func_216350_a().func_177971_a(rayTraceResult.func_216354_b().func_176730_m());
            this.spawnXpOnGround(stack, world, hitPos);
        } else if (player.field_71068_ca < this.getExperienceMaximum()) {
            int maxPoints = XpHelper.getExperienceForLevel(player.field_71068_ca + (levels += Math.round(player.field_71106_cc))) - player.field_71067_cb;
            int pointsToAdd = player.func_184812_l_() ? maxPoints : Math.min(maxPoints, this.getExperience(stack));
            this.increasePlayerExperience(player, pointsToAdd);
            if (!player.func_184812_l_()) {
                this.decreaseMedallionExperience(stack, pointsToAdd);
            }
        }
    }

    public void func_77615_a(ItemStack stack, World worldIn, LivingEntity entityLiving, int timeLeft) {
        if (entityLiving.field_70170_p.field_72995_K || this.isEnabled(stack) || !(entityLiving instanceof PlayerEntity) || this.func_77626_a(stack) - timeLeft > 10) {
            return;
        }
        this.increaseExperience(stack, (PlayerEntity)entityLiving, entityLiving.field_70170_p, 1);
    }

    private void spawnXpOnGround(ItemStack stack, World world, BlockPos hitPos) {
        int xp;
        if (this.getExperience(stack) >= xp) {
            int j;
            this.decreaseMedallionExperience(stack, xp);
            for (xp = Math.min((Integer)Settings.COMMON.items.heroMedallion.experienceDrop.get(), this.getExperience(stack)); xp > 0; xp -= j) {
                j = ExperienceOrbEntity.func_70527_a((int)xp);
                world.func_217376_c((Entity)new ExperienceOrbEntity(world, (double)hitPos.func_177958_n(), (double)hitPos.func_177956_o(), (double)hitPos.func_177952_p(), j));
            }
        }
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new FluidHandlerHeroMedallion(stack);
    }

    @Override
    public void update(ItemStack stack, IPedestal pedestal) {
        List<BlockPos> posInRange = pedestal.getPedestalsInRange((Integer)Settings.COMMON.items.heroMedallion.pedestalRange.get());
        World world = pedestal.getTheWorld();
        for (BlockPos pedestalPos : posInRange) {
            InventoryHelper.getInventoryAtPos(world, pedestalPos).ifPresent(pedestalInventory -> {
                List<ItemStack> toRepair = this.getMendingItemsForRepair((IItemHandler)pedestalInventory);
                for (ItemStack itemToRepair : toRepair) {
                    int xpToRepair = Math.min((Integer)Settings.COMMON.items.heroMedallion.pedestalRepairStepXP.get(), this.getExperience(stack));
                    int durabilityToRepair = Math.min(XpHelper.xpToDurability(xpToRepair), itemToRepair.func_77952_i());
                    this.setExperience(stack, this.getExperience(stack) - XpHelper.durabilityToXp(durabilityToRepair));
                    itemToRepair.func_196085_b(itemToRepair.func_77952_i() - durabilityToRepair);
                }
            });
        }
        pedestal.setActionCoolDown((Integer)Settings.COMMON.items.heroMedallion.pedestalCoolDown.get());
    }

    private List<ItemStack> getMendingItemsForRepair(IItemHandler inventory) {
        NonNullList stacksToReturn = NonNullList.func_191196_a();
        for (int slot = 0; slot < inventory.getSlots(); ++slot) {
            ItemStack stack = inventory.getStackInSlot(slot);
            if (!stack.func_77951_h() || stack.func_77952_i() <= 1 || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185296_A, (ItemStack)stack) <= 0) continue;
            stacksToReturn.add((Object)stack);
        }
        return stacksToReturn;
    }

    @Override
    public void onRemoved(ItemStack stack, IPedestal pedestal) {
    }

    @Override
    public void stop(ItemStack stack, IPedestal pedestal) {
    }
}

