/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.crafting.alkahestry;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.ConditionalRecipe;
import net.minecraftforge.common.crafting.conditions.ICondition;
import xreliquary.crafting.AlkahestryDrainRecipe;
import xreliquary.crafting.conditions.AlkahestryEnabledCondition;
import xreliquary.util.RegistryHelper;

public class DrainRecipeBuilder {
    private final Item itemResult;
    private final int charge;

    private DrainRecipeBuilder(IItemProvider itemResult, int charge) {
        this.itemResult = itemResult.func_199767_j();
        this.charge = charge;
    }

    public static DrainRecipeBuilder drainRecipe(IItemProvider result, int charge) {
        return new DrainRecipeBuilder(result, charge);
    }

    public void build(Consumer<IFinishedRecipe> consumer, ResourceLocation id) {
        ResourceLocation fullId = new ResourceLocation("xreliquary", "alkahestry/drain/" + id.func_110623_a());
        ConditionalRecipe.builder().addCondition((ICondition)new AlkahestryEnabledCondition()).addRecipe(conditionalConsumer -> conditionalConsumer.accept(new Result(fullId, this.itemResult, this.charge))).build(consumer, fullId);
    }

    public static class Result
    implements IFinishedRecipe {
        private final Item itemResult;
        private final int charge;
        private final ResourceLocation id;

        public Result(ResourceLocation id, Item itemResult, int charge) {
            this.id = id;
            this.itemResult = itemResult;
            this.charge = charge;
        }

        public void func_218610_a(JsonObject json) {
            json.addProperty("charge", (Number)this.charge);
            JsonObject resultObject = new JsonObject();
            resultObject.addProperty("item", RegistryHelper.getItemRegistryName(this.itemResult));
            json.add("result", (JsonElement)resultObject);
        }

        public ResourceLocation func_200442_b() {
            return this.id;
        }

        public IRecipeSerializer<?> func_218609_c() {
            return AlkahestryDrainRecipe.SERIALIZER;
        }

        @Nullable
        public JsonObject func_200440_c() {
            return null;
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return null;
        }
    }
}

