/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.crafting;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.IRequirementsStrategy;
import net.minecraft.advancements.criterion.RecipeUnlockedTrigger;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import xreliquary.util.RegistryHelper;

public class NbtShapedRecipeBuilder {
    private final Item result;
    private final int count;
    private final List<String> pattern = Lists.newArrayList();
    private final Map<Character, Ingredient> key = Maps.newLinkedHashMap();
    private final Advancement.Builder advancementBuilder = Advancement.Builder.func_200278_a();
    private String group;
    @Nullable
    private final CompoundNBT nbt;

    public NbtShapedRecipeBuilder(IItemProvider result, int count, @Nullable CompoundNBT nbt) {
        this.result = result.func_199767_j();
        this.count = count;
        this.nbt = nbt;
    }

    public static NbtShapedRecipeBuilder shapedRecipe(ItemStack stack) {
        return NbtShapedRecipeBuilder.shapedRecipe((IItemProvider)stack.func_77973_b(), stack.func_190916_E(), stack.func_77978_p());
    }

    public static NbtShapedRecipeBuilder shapedRecipe(IItemProvider resultIn, @Nullable CompoundNBT nbt) {
        return NbtShapedRecipeBuilder.shapedRecipe(resultIn, 1, nbt);
    }

    public static NbtShapedRecipeBuilder shapedRecipe(IItemProvider resultIn, int countIn, @Nullable CompoundNBT nbt) {
        return new NbtShapedRecipeBuilder(resultIn, countIn, nbt);
    }

    public NbtShapedRecipeBuilder key(Character symbol, ITag<Item> tagIn) {
        return this.key(symbol, Ingredient.func_199805_a(tagIn));
    }

    public NbtShapedRecipeBuilder key(Character symbol, IItemProvider itemIn) {
        return this.key(symbol, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{itemIn}));
    }

    public NbtShapedRecipeBuilder key(Character symbol, Ingredient ingredientIn) {
        if (this.key.containsKey(symbol)) {
            throw new IllegalArgumentException("Symbol '" + symbol + "' is already defined!");
        }
        if (symbol.charValue() == ' ') {
            throw new IllegalArgumentException("Symbol ' ' (whitespace) is reserved and cannot be defined");
        }
        this.key.put(symbol, ingredientIn);
        return this;
    }

    public NbtShapedRecipeBuilder patternLine(String patternIn) {
        if (!this.pattern.isEmpty() && patternIn.length() != this.pattern.get(0).length()) {
            throw new IllegalArgumentException("Pattern must be the same width on every line!");
        }
        this.pattern.add(patternIn);
        return this;
    }

    public NbtShapedRecipeBuilder addCriterion(String name, ICriterionInstance criterionIn) {
        this.advancementBuilder.func_200275_a(name, criterionIn);
        return this;
    }

    public NbtShapedRecipeBuilder setGroup(String groupIn) {
        this.group = groupIn;
        return this;
    }

    public void build(Consumer<IFinishedRecipe> consumerIn) {
        this.build(consumerIn, RegistryHelper.getRegistryName(this.result));
    }

    public void build(Consumer<IFinishedRecipe> consumerIn, String save) {
        ResourceLocation resourcelocation = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.result);
        if (new ResourceLocation(save).equals((Object)resourcelocation)) {
            throw new IllegalStateException("Shaped Recipe " + save + " should remove its 'save' argument");
        }
        this.build(consumerIn, new ResourceLocation(save));
    }

    public void build(Consumer<IFinishedRecipe> consumerIn, ResourceLocation id) {
        this.validate(id);
        this.advancementBuilder.func_200272_a(new ResourceLocation("recipes/root")).func_200275_a("has_the_recipe", (ICriterionInstance)RecipeUnlockedTrigger.func_235675_a_((ResourceLocation)id)).func_200271_a(AdvancementRewards.Builder.func_200280_c((ResourceLocation)id)).func_200270_a(IRequirementsStrategy.field_223215_b_);
        consumerIn.accept(new Result(id, this.result, this.count, this.nbt, this.group == null ? "" : this.group, this.pattern, this.key, this.advancementBuilder, new ResourceLocation(id.func_110624_b(), "recipes/" + this.result.func_77640_w().func_200300_c() + "/" + id.func_110623_a())));
    }

    private void validate(ResourceLocation id) {
        if (this.pattern.isEmpty()) {
            throw new IllegalStateException("No pattern is defined for shaped recipe " + id + "!");
        }
        HashSet set = Sets.newHashSet(this.key.keySet());
        set.remove(Character.valueOf(' '));
        for (String s : this.pattern) {
            for (int i = 0; i < s.length(); ++i) {
                char c0 = s.charAt(i);
                if (!this.key.containsKey(Character.valueOf(c0)) && c0 != ' ') {
                    throw new IllegalStateException("Pattern in recipe " + id + " uses undefined symbol '" + c0 + "'");
                }
                set.remove(Character.valueOf(c0));
            }
        }
        if (!set.isEmpty()) {
            throw new IllegalStateException("Ingredients are defined but not used in pattern for recipe " + id);
        }
        if (this.pattern.size() == 1 && this.pattern.get(0).length() == 1) {
            throw new IllegalStateException("Shaped recipe " + id + " only takes in a single item - should it be a shapeless recipe instead?");
        }
        if (this.advancementBuilder.func_200277_c().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + id);
        }
    }

    public static class Result
    implements IFinishedRecipe {
        private final ResourceLocation id;
        private final Item resultItem;
        private final int resultCount;
        @Nullable
        private final CompoundNBT resultNbt;
        private final String group;
        private final List<String> pattern;
        private final Map<Character, Ingredient> key;
        private final Advancement.Builder advancementBuilder;
        private final ResourceLocation advancementId;

        public Result(ResourceLocation idIn, Item resultIn, int countIn, @Nullable CompoundNBT resultNbt, String groupIn, List<String> patternIn, Map<Character, Ingredient> keyIn, Advancement.Builder advancementBuilderIn, ResourceLocation advancementIdIn) {
            this.id = idIn;
            this.resultItem = resultIn;
            this.resultCount = countIn;
            this.resultNbt = resultNbt;
            this.group = groupIn;
            this.pattern = patternIn;
            this.key = keyIn;
            this.advancementBuilder = advancementBuilderIn;
            this.advancementId = advancementIdIn;
        }

        public void func_218610_a(JsonObject json) {
            if (!this.group.isEmpty()) {
                json.addProperty("group", this.group);
            }
            JsonArray jsonarray = new JsonArray();
            for (String string : this.pattern) {
                jsonarray.add(string);
            }
            json.add("pattern", (JsonElement)jsonarray);
            JsonObject jsonobject = new JsonObject();
            for (Map.Entry<Character, Ingredient> entry : this.key.entrySet()) {
                jsonobject.add(String.valueOf(entry.getKey()), entry.getValue().func_200304_c());
            }
            json.add("key", (JsonElement)jsonobject);
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("item", RegistryHelper.getRegistryName(this.resultItem).toString());
            if (this.resultCount > 1) {
                jsonObject.addProperty("count", (Number)this.resultCount);
            }
            if (this.resultNbt != null) {
                jsonObject.addProperty("nbt", this.resultNbt.toString());
            }
            json.add("result", (JsonElement)jsonObject);
        }

        public IRecipeSerializer<?> func_218609_c() {
            return IRecipeSerializer.field_222157_a;
        }

        public ResourceLocation func_200442_b() {
            return this.id;
        }

        @Nullable
        public JsonObject func_200440_c() {
            return this.advancementBuilder.func_200273_b();
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return this.advancementId;
        }
    }
}

