/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.compat.jei.alkahestry;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import xreliquary.compat.jei.alkahestry.AlkahestryRecipeCategory;
import xreliquary.crafting.AlkahestryChargingRecipe;
import xreliquary.init.ModItems;
import xreliquary.items.AlkahestryTomeItem;
import xreliquary.reference.Reference;
import xreliquary.util.LanguageHelper;

public class AlkahestryChargingRecipeCategory
extends AlkahestryRecipeCategory<AlkahestryChargingRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("xreliquary", "alkahestry_charging");
    private static final int INPUT_SLOT = 0;
    private static final int TOME_SLOT = 1;
    private static final int OUTPUT_SLOT = 2;
    private final IDrawable background;
    private final String localizedName;

    public AlkahestryChargingRecipeCategory(IGuiHelper guiHelper) {
        super(guiHelper, UID);
        this.background = guiHelper.createDrawable(new ResourceLocation(Reference.DOMAIN + "textures/gui/jei/backgrounds.png"), 0, 0, 95, 36);
        this.localizedName = LanguageHelper.getLocalization("jei.xreliquary.recipe.alkahest_charging", new Object[0]);
    }

    public Class<? extends AlkahestryChargingRecipe> getRecipeClass() {
        return AlkahestryChargingRecipe.class;
    }

    public String getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void setIngredients(AlkahestryChargingRecipe recipe, IIngredients ingredients) {
        ingredients.setInputIngredients(recipe.func_192400_c());
        NonNullList outputs = NonNullList.func_191196_a();
        outputs.add((Object)recipe.func_77571_b());
        outputs.add((Object)AlkahestryTomeItem.setCharge(new ItemStack((IItemProvider)ModItems.ALKAHESTRY_TOME.get()), recipe.getChargeToAdd()));
        ingredients.setOutputs(VanillaTypes.ITEM, (List)outputs);
    }

    public void setRecipe(IRecipeLayout recipeLayout, AlkahestryChargingRecipe recipe, IIngredients ingredients) {
        recipeLayout.getItemStacks().init(0, true, 0, 0);
        recipeLayout.getItemStacks().init(1, true, 18, 0);
        recipeLayout.getItemStacks().init(2, false, 73, 9);
        List ingredientsInputs = ingredients.getInputs(VanillaTypes.ITEM);
        ItemStack input = (ItemStack)((List)ingredientsInputs.get(0)).get(0);
        ItemStack tome = (ItemStack)((List)ingredientsInputs.get(1)).get(0);
        ItemStack output = (ItemStack)((List)ingredients.getOutputs(VanillaTypes.ITEM).get(0)).get(0);
        recipeLayout.getItemStacks().set(0, input);
        recipeLayout.getItemStacks().set(1, tome);
        recipeLayout.getItemStacks().set(2, output);
    }

    public void draw(AlkahestryChargingRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        String chargeString = "+" + recipe.getChargeToAdd();
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        int stringWidth = fontRenderer.func_78256_a(chargeString);
        fontRenderer.func_238421_b_(matrixStack, chargeString, (float)(((double)this.background.getWidth() - (double)stringWidth) / 2.0), 3.0f, -8355712);
    }
}

