/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.compat.jei;

import java.util.Collections;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.subtypes.ISubtypeInterpreter;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.block.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import xreliquary.Reliquary;
import xreliquary.compat.jei.ItemDescriptionBuilder;
import xreliquary.compat.jei.MobCharmRecipeMaker;
import xreliquary.compat.jei.SortedNbtSubtypeInterpreter;
import xreliquary.compat.jei.SpawnEggRecipeMaker;
import xreliquary.compat.jei.alkahestry.AlkahestryChargingRecipeCategory;
import xreliquary.compat.jei.alkahestry.AlkahestryCraftingRecipeCategory;
import xreliquary.compat.jei.cauldron.CauldronRecipeCategory;
import xreliquary.compat.jei.cauldron.CauldronRecipeMaker;
import xreliquary.compat.jei.infernaltear.InfernalTearRecipeCategory;
import xreliquary.compat.jei.infernaltear.InfernalTearRecipeMaker;
import xreliquary.compat.jei.lingering.ArrowShotRecipeMaker;
import xreliquary.compat.jei.magazines.MagazineRecipeMaker;
import xreliquary.compat.jei.mortar.MortarRecipeCategory;
import xreliquary.compat.jei.mortar.MortarRecipeMaker;
import xreliquary.crafting.AlkahestryRecipeRegistry;
import xreliquary.init.ModBlocks;
import xreliquary.init.ModItems;
import xreliquary.items.MobCharmFragmentItem;
import xreliquary.reference.Settings;

@JeiPlugin
public class ReliquaryPlugin
implements IModPlugin {
    private static final String EFFECTS_TAG = "effects";

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        this.registerNbtSubtypeInterpreter(registration, (Item)ModItems.MOB_CHARM_FRAGMENT.get(), "entity");
        this.registerNbtSubtypeInterpreter(registration, (Item)ModItems.MOB_CHARM.get(), "entity");
        if (Boolean.FALSE.equals(Settings.COMMON.disable.disablePotions.get())) {
            this.registerNbtSubtypeInterpreter(registration, (Item)ModItems.POTION_ESSENCE.get(), EFFECTS_TAG);
            this.registerNbtSubtypeInterpreter(registration, (Item)ModItems.POTION.get(), EFFECTS_TAG);
            this.registerNbtSubtypeInterpreter(registration, (Item)ModItems.SPLASH_POTION.get(), EFFECTS_TAG);
            this.registerNbtSubtypeInterpreter(registration, (Item)ModItems.LINGERING_POTION.get(), EFFECTS_TAG);
            this.registerNbtSubtypeInterpreter(registration, (Item)ModItems.TIPPED_ARROW.get(), EFFECTS_TAG);
            this.registerNbtSubtypeInterpreter(registration, (Item)ModItems.NEUTRAL_BULLET.get(), EFFECTS_TAG);
            this.registerNbtSubtypeInterpreter(registration, (Item)ModItems.NEUTRAL_MAGAZINE.get(), EFFECTS_TAG);
        }
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper guiHelper = registration.getJeiHelpers().getGuiHelper();
        if (Boolean.FALSE.equals(Settings.COMMON.disable.disableAlkahestry.get())) {
            registration.addRecipeCategories(new IRecipeCategory[]{new AlkahestryCraftingRecipeCategory(guiHelper)});
            registration.addRecipeCategories(new IRecipeCategory[]{new AlkahestryChargingRecipeCategory(guiHelper)});
        }
        if (Boolean.FALSE.equals(Settings.COMMON.disable.disablePotions.get())) {
            registration.addRecipeCategories(new IRecipeCategory[]{new MortarRecipeCategory(guiHelper)});
            registration.addRecipeCategories(new IRecipeCategory[]{new CauldronRecipeCategory(guiHelper)});
        }
        registration.addRecipeCategories(new IRecipeCategory[]{new InfernalTearRecipeCategory(guiHelper)});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)Blocks.field_150462_ai), new ResourceLocation[]{AlkahestryChargingRecipeCategory.UID, AlkahestryCraftingRecipeCategory.UID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.APOTHECARY_MORTAR.get()), new ResourceLocation[]{MortarRecipeCategory.UID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.APOTHECARY_CAULDRON.get()), new ResourceLocation[]{CauldronRecipeCategory.UID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModItems.INFERNAL_TEAR.get()), new ResourceLocation[]{InfernalTearRecipeCategory.UID});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        if (Boolean.FALSE.equals(Settings.COMMON.disable.disableAlkahestry.get())) {
            registration.addRecipes(AlkahestryRecipeRegistry.getCraftingRecipes(), AlkahestryCraftingRecipeCategory.UID);
            registration.addRecipes(AlkahestryRecipeRegistry.getChargingRecipes(), AlkahestryChargingRecipeCategory.UID);
        }
        if (Boolean.FALSE.equals(Settings.COMMON.disable.disablePotions.get())) {
            registration.addRecipes(MortarRecipeMaker.getRecipes(), MortarRecipeCategory.UID);
            registration.addRecipes(CauldronRecipeMaker.getRecipes(), CauldronRecipeCategory.UID);
            registration.addRecipes(ArrowShotRecipeMaker.getRecipes(new ItemStack((IItemProvider)ModItems.TIPPED_ARROW.get()), new ItemStack((IItemProvider)Items.field_151032_g), 0.125f, "arrow"), VanillaRecipeCategoryUid.CRAFTING);
            registration.addRecipes(ArrowShotRecipeMaker.getRecipes(new ItemStack((IItemProvider)ModItems.NEUTRAL_BULLET.get()), "bullet"), VanillaRecipeCategoryUid.CRAFTING);
        }
        if (Boolean.FALSE.equals(Settings.COMMON.disable.disableHandgun.get())) {
            registration.addRecipes(MagazineRecipeMaker.getRecipes(), VanillaRecipeCategoryUid.CRAFTING);
        }
        registration.addRecipes(MobCharmRecipeMaker.getRecipes(), VanillaRecipeCategoryUid.CRAFTING);
        if (Boolean.FALSE.equals(Settings.COMMON.disable.disableSpawnEggRecipes.get())) {
            registration.addRecipes(SpawnEggRecipeMaker.getRecipes(), VanillaRecipeCategoryUid.CRAFTING);
        }
        registration.addRecipes(InfernalTearRecipeMaker.getRecipes(), InfernalTearRecipeCategory.UID);
        this.registerMobCharmBeltRecipe(registration);
        ItemDescriptionBuilder.addIngredientInfo(registration);
    }

    private void registerMobCharmBeltRecipe(IRecipeRegistration registration) {
        NonNullList fragments = NonNullList.func_191196_a();
        ((MobCharmFragmentItem)ModItems.MOB_CHARM_FRAGMENT.get()).func_150895_a(Reliquary.ITEM_GROUP, (NonNullList<ItemStack>)fragments);
        ItemStack[] fragmentStacks = (ItemStack[])fragments.toArray((Object[])new ItemStack[0]);
        registration.addRecipes(Collections.singleton(new ShapedRecipe(new ResourceLocation("xreliquary", "items/mob_charm_belt"), "", 3, 3, NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{() -> Items.field_151116_aA}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{() -> Items.field_151116_aA}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{() -> Items.field_151116_aA}), Ingredient.func_193369_a((ItemStack[])fragmentStacks), Ingredient.field_193370_a, Ingredient.func_193369_a((ItemStack[])fragmentStacks), Ingredient.func_193369_a((ItemStack[])fragmentStacks), Ingredient.func_193369_a((ItemStack[])fragmentStacks), Ingredient.func_193369_a((ItemStack[])fragmentStacks)}), new ItemStack((IItemProvider)ModItems.MOB_CHARM_BELT.get()))), VanillaRecipeCategoryUid.CRAFTING);
    }

    private void registerNbtSubtypeInterpreter(ISubtypeRegistration registration, Item item, String ... keys) {
        registration.registerSubtypeInterpreter(item, (ISubtypeInterpreter)new SortedNbtSubtypeInterpreter(keys));
    }

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("xreliquary", "default");
    }
}

