/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.client;

import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.entity.SpriteRenderer;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.item.FishingRodItem;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemModelsProperties;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import xreliquary.client.init.ModBlockColors;
import xreliquary.client.init.ModItemColors;
import xreliquary.client.init.ModParticles;
import xreliquary.client.registry.PedestalClientRegistry;
import xreliquary.client.render.ApothecaryMortarRenderer;
import xreliquary.client.render.LyssaHookRenderer;
import xreliquary.client.render.PassivePedestalRenderer;
import xreliquary.client.render.PedestalFishHookRenderer;
import xreliquary.client.render.PedestalRenderer;
import xreliquary.client.render.ShotRenderer;
import xreliquary.client.render.XRTippedArrowRenderer;
import xreliquary.common.CommonProxy;
import xreliquary.init.ModBlocks;
import xreliquary.init.ModEntities;
import xreliquary.init.ModItems;
import xreliquary.items.FortuneCoinToggler;
import xreliquary.items.InfernalTearItem;
import xreliquary.items.RodOfLyssaItem;
import xreliquary.items.VoidTearItem;
import xreliquary.util.potions.XRPotionHelper;

@OnlyIn(value=Dist.CLIENT)
public class ClientProxy
extends CommonProxy {
    public static final KeyBinding FORTUNE_COIN_TOGGLE_KEYBIND = new KeyBinding("keybind.xreliquary.fortune_coin", InputMappings.field_197958_a.func_197937_c(), "keybind.xreliquary.category");

    @Override
    public void registerHandlers() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.addListener(this::clientSetup);
        modBus.addListener(this::loadComplete);
        modBus.addListener(ModParticles.FactoryHandler::registerFactories);
        modBus.addListener(this::registerEntityRenderers);
        modBus.addListener(this::registerTileRenderers);
    }

    private void registerEntityRenderers(FMLClientSetupEvent event) {
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.LYSSA_HOOK, LyssaHookRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.BLAZE_SHOT, ShotRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.BUSTER_SHOT, ShotRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.CONCUSSIVE_SHOT, ShotRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.ENDER_SHOT, ShotRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.EXORCISM_SHOT, ShotRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.NEUTRAL_SHOT, ShotRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.SEEKER_SHOT, ShotRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.SAND_SHOT, ShotRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.STORM_SHOT, ShotRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.TIPPED_ARROW, XRTippedArrowRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.GLOWING_WATER, renderManager -> new SpriteRenderer(renderManager, Minecraft.func_71410_x().func_175599_af()));
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.APHRODITE_POTION, renderManager -> new SpriteRenderer(renderManager, Minecraft.func_71410_x().func_175599_af()));
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.FERTILE_POTION, renderManager -> new SpriteRenderer(renderManager, Minecraft.func_71410_x().func_175599_af()));
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.HOLY_HAND_GRENADE, renderManager -> new SpriteRenderer(renderManager, Minecraft.func_71410_x().func_175599_af()));
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.KRAKEN_SLIME, renderManager -> new SpriteRenderer(renderManager, Minecraft.func_71410_x().func_175599_af()));
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.SPECIAL_SNOWBALL, renderManager -> new SpriteRenderer(renderManager, Minecraft.func_71410_x().func_175599_af()));
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.ENDER_STAFF_PROJECTILE, renderManager -> new SpriteRenderer(renderManager, Minecraft.func_71410_x().func_175599_af()));
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.THROWN_POTION, renderManager -> new SpriteRenderer(renderManager, Minecraft.func_71410_x().func_175599_af()));
    }

    private void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> ClientRegistry.registerKeyBinding((KeyBinding)FORTUNE_COIN_TOGGLE_KEYBIND));
        event.enqueueWork(() -> ItemModelsProperties.func_239418_a_((Item)((Item)ModItems.ROD_OF_LYSSA.get()), (ResourceLocation)new ResourceLocation("cast"), (stack, world, entity) -> {
            if (entity == null) {
                return 0.0f;
            }
            if (world == null) {
                return 0.0f;
            }
            int entityId = RodOfLyssaItem.getHookEntityId(stack);
            return (entity.func_184614_ca() == stack || entity.func_184592_cb() == stack) && entityId > 0 && world.func_73045_a(entityId) != null ? 1.0f : 0.0f;
        }));
        event.enqueueWork(() -> ItemModelsProperties.func_239418_a_((Item)((Item)ModItems.INFERNAL_TEAR.get()), (ResourceLocation)new ResourceLocation("empty"), (stack, world, entity) -> InfernalTearItem.getStackFromTear(stack).func_190926_b() ? 1.0f : 0.0f));
        event.enqueueWork(() -> ItemModelsProperties.func_239418_a_((Item)((Item)ModItems.VOID_TEAR.get()), (ResourceLocation)new ResourceLocation("empty"), (stack, world, entity) -> VoidTearItem.isEmpty(stack, true) ? 1.0f : 0.0f));
        event.enqueueWork(() -> this.registerPropertyToItems(new ResourceLocation("xreliquary", "potion"), (stack, world, livingEntity) -> this.isPotionAttached(stack) ? 1.0f : 0.0f, (Item)ModItems.BLAZE_BULLET.get(), (Item)ModItems.BUSTER_BULLET.get(), (Item)ModItems.CONCUSSIVE_BULLET.get(), (Item)ModItems.ENDER_BULLET.get(), (Item)ModItems.EXORCISM_BULLET.get(), (Item)ModItems.NEUTRAL_BULLET.get(), (Item)ModItems.SAND_BULLET.get(), (Item)ModItems.SEEKER_BULLET.get(), (Item)ModItems.STORM_BULLET.get(), (Item)ModItems.BLAZE_MAGAZINE.get(), (Item)ModItems.BUSTER_MAGAZINE.get(), (Item)ModItems.CONCUSSIVE_MAGAZINE.get(), (Item)ModItems.ENDER_MAGAZINE.get(), (Item)ModItems.EXORCISM_MAGAZINE.get(), (Item)ModItems.NEUTRAL_MAGAZINE.get(), (Item)ModItems.SAND_MAGAZINE.get(), (Item)ModItems.SEEKER_MAGAZINE.get(), (Item)ModItems.STORM_MAGAZINE.get()));
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.FERTILE_LILY_PAD.get()), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.INTERDICTION_TORCH.get()), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.WALL_INTERDICTION_TORCH.get()), (RenderType)RenderType.func_228643_e_());
    }

    public void registerPropertyToItems(ResourceLocation registryName, IItemPropertyGetter propertyGetter, Item ... items) {
        for (Item item : items) {
            ItemModelsProperties.func_239418_a_((Item)item, (ResourceLocation)registryName, (IItemPropertyGetter)propertyGetter);
        }
    }

    private boolean isPotionAttached(ItemStack stack) {
        return !XRPotionHelper.getPotionEffectsFromStack(stack).isEmpty();
    }

    private void loadComplete(FMLLoadCompleteEvent event) {
        event.enqueueWork(() -> {
            ModItemColors.init();
            ModBlockColors.init();
            PedestalClientRegistry.registerItemRenderer(FishingRodItem.class, PedestalFishHookRenderer.class);
            MinecraftForge.EVENT_BUS.addListener(FortuneCoinToggler::handleKeyInputEvent);
        });
    }

    private void registerTileRenderers(FMLClientSetupEvent event) {
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)ModBlocks.APOTHECARY_MORTAR_TILE_TYPE.get()), ApothecaryMortarRenderer::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)ModBlocks.PEDESTAL_TILE_TYPE.get()), PedestalRenderer::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)ModBlocks.PASSIVE_PEDESTAL_TILE_TYPE.get()), PassivePedestalRenderer::new);
    }
}

