/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.pedestal.wrappers;

import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import xreliquary.api.IPedestal;
import xreliquary.api.IPedestalActionItemWrapper;
import xreliquary.init.ModItems;
import xreliquary.init.ModPotions;
import xreliquary.items.RendingGaleItem;
import xreliquary.reference.Settings;

public class PedestalRendingGaleWrapper
implements IPedestalActionItemWrapper {
    private static final int SECONDS_BETWEEN_BUFF_CHECKS = 2;
    private static final int TICKS_BETWEEN_PUSH_PULL_CHECKS = 1;
    private int buffCheckCoolDown;
    private int pushPullCheckCoolDown;

    @Override
    public void update(ItemStack stack, IPedestal pedestal) {
        World world = pedestal.getTheWorld();
        BlockPos pos = pedestal.getBlockPos();
        RendingGaleItem rendingGale = (RendingGaleItem)stack.func_77973_b();
        if (rendingGale.getMode(stack).equals("flight")) {
            if (this.buffCheckCoolDown <= 0) {
                this.buffPlayersWithFlight(stack, world, pos);
                this.buffCheckCoolDown = 40;
            } else {
                --this.buffCheckCoolDown;
            }
        } else if (rendingGale.getMode(stack).equals("push")) {
            if (this.pushPullCheckCoolDown <= 0) {
                this.pushEntities(stack, world, pos, rendingGale, false);
                this.pushPullCheckCoolDown = 1;
            } else {
                --this.pushPullCheckCoolDown;
            }
        } else if (rendingGale.getMode(stack).equals("pull")) {
            if (this.pushPullCheckCoolDown <= 0) {
                this.pushEntities(stack, world, pos, rendingGale, true);
                this.pushPullCheckCoolDown = 1;
            } else {
                --this.pushPullCheckCoolDown;
            }
        }
    }

    private void pushEntities(ItemStack stack, World world, BlockPos pos, RendingGaleItem rendingGale, boolean b) {
        rendingGale.doRadialPush(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), null, b);
        ((RendingGaleItem)ModItems.RENDING_GALE.get()).setFeatherCount(stack, ((RendingGaleItem)ModItems.RENDING_GALE.get()).getFeatherCount(stack) - (int)(0.05f * (float)((Integer)Settings.COMMON.items.rendingGale.pedestalCostPerSecond.get()).intValue()), true);
    }

    private void buffPlayersWithFlight(ItemStack stack, World world, BlockPos pos) {
        List players;
        int flightRange = (Integer)Settings.COMMON.items.rendingGale.pedestalFlightRange.get();
        if (((RendingGaleItem)ModItems.RENDING_GALE.get()).getFeatherCount(stack) >= RendingGaleItem.getChargeCost() * 2 && !(players = world.func_217357_a(PlayerEntity.class, new AxisAlignedBB((double)pos.func_177958_n() - (double)flightRange, (double)pos.func_177956_o() - (double)flightRange, (double)pos.func_177952_p() - (double)flightRange, (double)pos.func_177958_n() + (double)flightRange, (double)pos.func_177956_o() + (double)flightRange, (double)pos.func_177952_p() + (double)flightRange))).isEmpty()) {
            for (PlayerEntity player : players) {
                player.func_195064_c(new EffectInstance(ModPotions.potionFlight, 400));
            }
            ((RendingGaleItem)ModItems.RENDING_GALE.get()).setFeatherCount(stack, ((RendingGaleItem)ModItems.RENDING_GALE.get()).getFeatherCount(stack) - 2 * (Integer)Settings.COMMON.items.rendingGale.pedestalCostPerSecond.get(), true);
        }
    }

    @Override
    public void onRemoved(ItemStack stack, IPedestal pedestal) {
    }

    @Override
    public void stop(ItemStack stack, IPedestal pedestal) {
    }
}

