/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.network;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.network.NetworkEvent;
import xreliquary.compat.curios.CuriosCompat;
import xreliquary.init.ModItems;
import xreliquary.items.FortuneCoinItem;
import xreliquary.items.util.IBaubleItem;

public class PacketFortuneCoinTogglePressed {
    private final InventoryType inventoryType;
    private final int slot;

    public PacketFortuneCoinTogglePressed(InventoryType inventoryType, int slot) {
        this.inventoryType = inventoryType;
        this.slot = slot;
    }

    static void encode(PacketFortuneCoinTogglePressed msg, PacketBuffer packetBuffer) {
        packetBuffer.writeByte(msg.inventoryType.ordinal());
        packetBuffer.writeInt(msg.slot);
    }

    static PacketFortuneCoinTogglePressed decode(PacketBuffer packetBuffer) {
        return new PacketFortuneCoinTogglePressed(InventoryType.values()[packetBuffer.readByte()], packetBuffer.readInt());
    }

    static void onMessage(PacketFortuneCoinTogglePressed msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> PacketFortuneCoinTogglePressed.handleMessage(msg, context.getSender()));
        context.setPacketHandled(true);
    }

    private static void handleMessage(PacketFortuneCoinTogglePressed message, @Nullable ServerPlayerEntity player) {
        if (player == null) {
            return;
        }
        switch (message.inventoryType) {
            case MAIN: {
                ItemStack stack2 = (ItemStack)player.field_71071_by.field_70462_a.get(message.slot);
                if (stack2.func_77973_b() != ModItems.FORTUNE_COIN.get()) break;
                ((FortuneCoinItem)ModItems.FORTUNE_COIN.get()).toggle(stack2);
                PacketFortuneCoinTogglePressed.showMessage(player, stack2);
                break;
            }
            case OFF_HAND: {
                ItemStack stack1 = (ItemStack)player.field_71071_by.field_184439_c.get(0);
                if (stack1.func_77973_b() != ModItems.FORTUNE_COIN.get()) break;
                ((FortuneCoinItem)ModItems.FORTUNE_COIN.get()).toggle(stack1);
                PacketFortuneCoinTogglePressed.showMessage(player, stack1);
                break;
            }
            case CURIOS: {
                PacketFortuneCoinTogglePressed.run(() -> () -> CuriosCompat.getStackInSlot((LivingEntity)player, IBaubleItem.Type.NECKLACE.getIdentifier(), message.slot).ifPresent(stack -> {
                    if (stack.func_77973_b() == ModItems.FORTUNE_COIN.get()) {
                        ((FortuneCoinItem)ModItems.FORTUNE_COIN.get()).toggle((ItemStack)stack);
                        PacketFortuneCoinTogglePressed.showMessage(player, stack);
                        CuriosCompat.setStackInSlot((LivingEntity)player, IBaubleItem.Type.NECKLACE.getIdentifier(), message.slot, stack);
                    }
                }));
            }
        }
    }

    private static void showMessage(ServerPlayerEntity player, ItemStack fortuneCoin) {
        player.func_146105_b((ITextComponent)new TranslationTextComponent("chat.xreliquary.fortune_coin.toggle", new Object[]{FortuneCoinItem.isEnabled(fortuneCoin) ? new TranslationTextComponent("chat.xreliquary.fortune_coin.on").func_240699_a_(TextFormatting.GREEN) : new TranslationTextComponent("chat.xreliquary.fortune_coin.off").func_240699_a_(TextFormatting.RED)}), true);
    }

    private static void run(Supplier<Runnable> toRun) {
        toRun.get().run();
    }

    public static enum InventoryType {
        MAIN,
        OFF_HAND,
        CURIOS;

    }
}

