/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items.util.fluid;

import javax.annotation.Nullable;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import xreliquary.init.ModFluids;
import xreliquary.init.ModItems;
import xreliquary.items.HeroMedallionItem;
import xreliquary.util.XpHelper;

public class FluidHandlerHeroMedallion
implements IFluidHandlerItem,
ICapabilityProvider {
    private static final int MAX_CAPACITY = Integer.MAX_VALUE;
    private final ItemStack heroMedallion;

    public FluidHandlerHeroMedallion(ItemStack heroMedallion) {
        this.heroMedallion = heroMedallion;
    }

    public ItemStack getContainer() {
        return this.heroMedallion;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        return CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY.orEmpty(cap, LazyOptional.of(() -> this));
    }

    public int getTanks() {
        return 1;
    }

    public FluidStack getFluidInTank(int tank) {
        return new FluidStack((Fluid)ModFluids.XP_JUICE_STILL.get(), XpHelper.experienceToLiquid(this.getMedallionXp()));
    }

    public int getTankCapacity(int tank) {
        return Integer.MAX_VALUE;
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        return tank == 0 && this.isXpJuiceFluid(stack);
    }

    private boolean isXpJuiceFluid(FluidStack stack) {
        return FluidTags.func_226157_a_().func_241834_b(ModFluids.EXPERIENCE_TAG).func_230235_a_((Object)stack.getFluid());
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (!this.isXpJuiceFluid(resource)) {
            return 0;
        }
        int currentXp = this.getMedallionXp();
        int toFill = Math.min(Integer.MAX_VALUE - XpHelper.experienceToLiquid(currentXp), resource.getAmount());
        if (action == IFluidHandler.FluidAction.EXECUTE) {
            ((HeroMedallionItem)ModItems.HERO_MEDALLION.get()).setExperience(this.heroMedallion, currentXp + XpHelper.liquidToExperience(toFill));
        }
        return toFill;
    }

    private int getMedallionXp() {
        return ((HeroMedallionItem)ModItems.HERO_MEDALLION.get()).getExperience(this.heroMedallion);
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (!this.isXpJuiceFluid(resource)) {
            return FluidStack.EMPTY;
        }
        int currentXp = this.getMedallionXp();
        int currentLiquidXp = XpHelper.experienceToLiquid(currentXp);
        int toDrain = Math.min(currentLiquidXp, resource.getAmount());
        if (action == IFluidHandler.FluidAction.EXECUTE) {
            ((HeroMedallionItem)ModItems.HERO_MEDALLION.get()).setExperience(this.heroMedallion, currentXp - XpHelper.liquidToExperience(toDrain));
        }
        return new FluidStack(resource.getFluid(), toDrain);
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        return this.drain(new FluidStack((Fluid)ModFluids.XP_JUICE_STILL.get(), maxDrain), action);
    }
}

