/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import xreliquary.handler.CommonEventHandler;
import xreliquary.handler.HandlerPriority;
import xreliquary.handler.IPlayerDeathHandler;
import xreliquary.handler.IPlayerHurtHandler;
import xreliquary.init.ModItems;
import xreliquary.items.AngelicFeatherItem;
import xreliquary.network.PacketHandler;
import xreliquary.network.SpawnPhoenixDownParticlesPacket;
import xreliquary.reference.Settings;
import xreliquary.util.EntityHelper;
import xreliquary.util.InventoryHelper;

public class PhoenixDownItem
extends AngelicFeatherItem {
    public PhoenixDownItem() {
        CommonEventHandler.registerPlayerHurtHandler(new IPlayerHurtHandler(){

            @Override
            public boolean canApply(PlayerEntity player, LivingAttackEvent event) {
                return event.getSource() == DamageSource.field_76379_h && player.func_110143_aJ() > (float)Math.round(event.getAmount()) && player.func_71024_bL().func_75116_a() > 0 && InventoryHelper.playerHasItem(player, (Item)ModItems.PHOENIX_DOWN.get());
            }

            @Override
            public boolean apply(PlayerEntity player, LivingAttackEvent event) {
                float hungerDamage = event.getAmount() * ((float)((Integer)Settings.COMMON.items.phoenixDown.hungerCostPercent.get()).intValue() / 100.0f);
                player.func_71020_j(hungerDamage);
                return true;
            }

            @Override
            public HandlerPriority getPriority() {
                return HandlerPriority.HIGH;
            }
        });
        CommonEventHandler.registerPlayerDeathHandler(new IPlayerDeathHandler(){

            @Override
            public boolean canApply(PlayerEntity player, LivingDeathEvent event) {
                return InventoryHelper.playerHasItem(player, (Item)ModItems.PHOENIX_DOWN.get());
            }

            @Override
            public boolean apply(PlayerEntity player, LivingDeathEvent event) {
                PhoenixDownItem.revertPhoenixDownToAngelicFeather(player);
                float amountHealed = player.func_110138_aP() * (float)((Integer)Settings.COMMON.items.phoenixDown.healPercentageOfMaxLife.get()).intValue() / 100.0f;
                player.func_70606_j(amountHealed);
                if (((Boolean)Settings.COMMON.items.phoenixDown.removeNegativeStatus.get()).booleanValue()) {
                    EntityHelper.removeNegativeStatusEffects((LivingEntity)player);
                }
                if (event.getSource() == DamageSource.field_76371_c && ((Boolean)Settings.COMMON.items.phoenixDown.giveTemporaryFireResistanceIfFireDamageKilledYou.get()).booleanValue()) {
                    player.func_195064_c(new EffectInstance(Effects.field_76426_n, 200, 0));
                }
                if (event.getSource() == DamageSource.field_76369_e && ((Boolean)Settings.COMMON.items.phoenixDown.giveTemporaryWaterBreathingIfDrowningKilledYou.get()).booleanValue()) {
                    player.func_70050_g(10);
                    player.func_195064_c(new EffectInstance(Effects.field_76427_o, 200, 0));
                }
                if (((Boolean)Settings.COMMON.items.phoenixDown.giveTemporaryDamageResistance.get()).booleanValue()) {
                    player.func_195064_c(new EffectInstance(Effects.field_76429_m, 200, 1));
                }
                if (((Boolean)Settings.COMMON.items.phoenixDown.giveTemporaryRegeneration.get()).booleanValue()) {
                    player.func_195064_c(new EffectInstance(Effects.field_76428_l, 200, 1));
                }
                PhoenixDownItem.spawnPhoenixResurrectionParticles(player);
                return true;
            }

            @Override
            public HandlerPriority getPriority() {
                return HandlerPriority.LOW;
            }
        });
    }

    private static void revertPhoenixDownToAngelicFeather(PlayerEntity player) {
        for (int slot = 0; slot < player.field_71071_by.field_70462_a.size(); ++slot) {
            if (((ItemStack)player.field_71071_by.field_70462_a.get(slot)).func_190926_b() || ((ItemStack)player.field_71071_by.field_70462_a.get(slot)).func_77973_b() != ModItems.PHOENIX_DOWN.get()) continue;
            player.field_71071_by.field_70462_a.set(slot, (Object)new ItemStack((IItemProvider)ModItems.ANGELIC_FEATHER.get()));
            return;
        }
    }

    private static void spawnPhoenixResurrectionParticles(PlayerEntity player) {
        PacketHandler.sendToClient((ServerPlayerEntity)player, new SpawnPhoenixDownParticlesPacket());
    }
}

