/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.crafting;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.AddReloadListenerEvent;
import xreliquary.crafting.AlkahestryChargingRecipe;
import xreliquary.crafting.AlkahestryCraftingRecipe;
import xreliquary.crafting.AlkahestryDrainRecipe;

public class AlkahestryRecipeRegistry {
    @Nullable
    private static AlkahestryDrainRecipe drainRecipe = null;
    private static final Map<ResourceLocation, AlkahestryCraftingRecipe> craftingRecipes = new LinkedHashMap<ResourceLocation, AlkahestryCraftingRecipe>();
    private static final Map<ResourceLocation, AlkahestryChargingRecipe> chargingRecipes = new LinkedHashMap<ResourceLocation, AlkahestryChargingRecipe>();

    private AlkahestryRecipeRegistry() {
    }

    static void setDrainRecipe(AlkahestryDrainRecipe drainRecipe) {
        AlkahestryRecipeRegistry.drainRecipe = drainRecipe;
    }

    public static Optional<AlkahestryDrainRecipe> getDrainRecipe() {
        return Optional.ofNullable(drainRecipe);
    }

    public static Collection<AlkahestryCraftingRecipe> getCraftingRecipes() {
        return craftingRecipes.values();
    }

    static void registerCraftingRecipe(AlkahestryCraftingRecipe alkahestryCraftingRecipe) {
        craftingRecipes.put(alkahestryCraftingRecipe.func_199560_c(), alkahestryCraftingRecipe);
    }

    static void registerChargingRecipe(AlkahestryChargingRecipe alkahestryChargingRecipe) {
        chargingRecipes.put(alkahestryChargingRecipe.func_199560_c(), alkahestryChargingRecipe);
    }

    public static Collection<AlkahestryChargingRecipe> getChargingRecipes() {
        return chargingRecipes.values();
    }

    public static void onResourceReload(AddReloadListenerEvent event) {
        drainRecipe = null;
        craftingRecipes.clear();
        chargingRecipes.clear();
    }
}

