/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.screen.widget;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.refinedmods.refinedstorage.integration.jei.GridRecipeTransferHandler;
import com.refinedmods.refinedstorage.integration.jei.JeiIntegration;
import com.refinedmods.refinedstorage.screen.BaseScreen;
import com.refinedmods.refinedstorage.screen.widget.ScrollbarWidgetListener;
import com.refinedmods.refinedstorage.util.RenderUtils;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.gui.IGuiEventListener;

public class ScrollbarWidget
implements IGuiEventListener {
    private static final int SCROLLER_HEIGHT = 15;
    private final int x;
    private final int y;
    private final int width;
    private final int height;
    private boolean enabled = false;
    private int offset;
    private int maxOffset;
    private boolean clicked = false;
    private boolean small = false;
    private final List<ScrollbarWidgetListener> listeners = new LinkedList<ScrollbarWidgetListener>();
    private final BaseScreen<?> screen;

    public ScrollbarWidget(BaseScreen<?> screen, int x, int y, int width, int height) {
        this.screen = screen;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public ScrollbarWidget(BaseScreen screen, int x, int y, int width, int height, boolean small) {
        this(screen, x, y, width, height);
        this.small = small;
    }

    public void addListener(ScrollbarWidgetListener listener) {
        this.listeners.add(listener);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void render(MatrixStack matrixStack) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.screen.bindTexture("refinedstorage", "icons.png");
        if (this.small) {
            this.screen.func_238474_b_(matrixStack, this.screen.getGuiLeft() + this.x, this.screen.getGuiTop() + this.y + (int)Math.min((float)(this.height - 15), (float)this.offset / (float)this.maxOffset * (float)(this.height - 15)), this.isEnabled() ? 218 : 225, 0, 7, 15);
        } else {
            this.screen.func_238474_b_(matrixStack, this.screen.getGuiLeft() + this.x, this.screen.getGuiTop() + this.y + (int)Math.min((float)(this.height - 15), (float)this.offset / (float)this.maxOffset * (float)(this.height - 15)), this.isEnabled() ? 232 : 244, 0, 12, 15);
        }
    }

    public boolean func_231044_a_(double mx, double my, int button) {
        if (button == 0 && RenderUtils.inBounds(this.x, this.y, this.width, this.height, mx -= (double)this.screen.getGuiLeft(), my -= (double)this.screen.getGuiTop())) {
            if (JeiIntegration.isLoaded() && GridRecipeTransferHandler.INSTANCE.hasTransferredRecently()) {
                return false;
            }
            this.updateOffset(my);
            this.clicked = true;
            return true;
        }
        return false;
    }

    public void func_212927_b(double mx, double my) {
        if (this.clicked && RenderUtils.inBounds(this.x, this.y, this.width, this.height, mx -= (double)this.screen.getGuiLeft(), my -= (double)this.screen.getGuiTop())) {
            this.updateOffset(my);
        }
    }

    private void updateOffset(double my) {
        this.setOffset((int)Math.floor((float)(my - (double)this.y) / (float)(this.height - 15) * (float)this.maxOffset));
    }

    public boolean func_231048_c_(double mx, double my, int button) {
        if (this.clicked) {
            this.clicked = false;
            return true;
        }
        return false;
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double scrollDelta) {
        if (this.isEnabled()) {
            this.setOffset(this.offset + Math.max(Math.min(-((int)scrollDelta), 1), -1));
            return true;
        }
        return false;
    }

    public void setMaxOffset(int maxOffset) {
        this.maxOffset = maxOffset;
        if (this.offset > maxOffset) {
            this.offset = Math.max(0, maxOffset);
        }
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        int oldOffset = this.offset;
        if (offset >= 0 && offset <= this.maxOffset) {
            this.offset = offset;
            this.listeners.forEach(l -> l.onOffsetChanged(oldOffset, offset));
        }
    }
}

