/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.screen;

import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.container.FluidAmountContainer;
import com.refinedmods.refinedstorage.network.SetFluidFilterSlotMessage;
import com.refinedmods.refinedstorage.screen.AmountSpecifyingScreen;
import com.refinedmods.refinedstorage.screen.BaseScreen;
import com.refinedmods.refinedstorage.util.StackUtils;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;

public class FluidAmountScreen
extends AmountSpecifyingScreen<FluidAmountContainer> {
    private final int containerSlot;
    private final FluidStack stack;
    private final int maxAmount;
    @Nullable
    private final UnaryOperator<Screen> alternativesScreenFactory;

    public FluidAmountScreen(BaseScreen parent, PlayerEntity player, int containerSlot, FluidStack stack, int maxAmount, @Nullable UnaryOperator<Screen> alternativesScreenFactory) {
        super(parent, new FluidAmountContainer(player, stack), alternativesScreenFactory != null ? 194 : 172, 99, player.field_71071_by, (ITextComponent)new TranslationTextComponent("gui.refinedstorage.fluid_amount"));
        this.containerSlot = containerSlot;
        this.stack = stack;
        this.maxAmount = maxAmount;
        this.alternativesScreenFactory = alternativesScreenFactory;
    }

    @Override
    protected int getOkCancelButtonWidth() {
        return this.alternativesScreenFactory != null ? 75 : super.getOkCancelButtonWidth();
    }

    @Override
    public void onPostInit(int x, int y) {
        super.onPostInit(x, y);
        if (this.alternativesScreenFactory != null) {
            this.addButton(x + 114, this.cancelButton.field_230691_m_ + 24, this.getOkCancelButtonWidth(), 20, (ITextComponent)new TranslationTextComponent("gui.refinedstorage.alternatives"), true, true, btn -> this.field_230706_i_.func_147108_a((Screen)this.alternativesScreenFactory.apply((Screen)this)));
        }
    }

    @Override
    protected Pair<Integer, Integer> getOkCancelPos() {
        if (this.alternativesScreenFactory == null) {
            return super.getOkCancelPos();
        }
        return Pair.of((Object)114, (Object)22);
    }

    @Override
    protected int getDefaultAmount() {
        return this.stack.getAmount();
    }

    @Override
    protected boolean canAmountGoNegative() {
        return false;
    }

    @Override
    protected int getMaxAmount() {
        return this.maxAmount;
    }

    @Override
    protected ITextComponent getOkButtonText() {
        return new TranslationTextComponent("misc.refinedstorage.set");
    }

    @Override
    protected String getTexture() {
        return this.alternativesScreenFactory != null ? "gui/amount_specifying_wide.png" : "gui/amount_specifying.png";
    }

    @Override
    protected int[] getIncrements() {
        return new int[]{100, 500, 1000, -100, -500, -1000};
    }

    @Override
    protected void onOkButtonPressed(boolean shiftDown) {
        try {
            int amount = Integer.parseInt(this.amountField.func_146179_b());
            RS.NETWORK_HANDLER.sendToServer(new SetFluidFilterSlotMessage(this.containerSlot, StackUtils.copy(this.stack, amount)));
            this.close();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }
}

