/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.item;

import com.refinedmods.refinedstorage.api.network.INetwork;
import com.refinedmods.refinedstorage.api.network.item.INetworkItemProvider;
import com.refinedmods.refinedstorage.inventory.player.PlayerSlot;
import com.refinedmods.refinedstorage.item.EnergyItem;
import com.refinedmods.refinedstorage.render.Styles;
import com.refinedmods.refinedstorage.util.NetworkUtils;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public abstract class NetworkItem
extends EnergyItem
implements INetworkItemProvider {
    private static final String NBT_NODE_X = "NodeX";
    private static final String NBT_NODE_Y = "NodeY";
    private static final String NBT_NODE_Z = "NodeZ";
    private static final String NBT_DIMENSION = "Dimension";

    protected NetworkItem(Item.Properties item, boolean creative, Supplier<Integer> energyCapacity) {
        super(item, creative, energyCapacity);
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            this.applyNetwork(world.func_73046_m(), stack, n -> n.getNetworkItemManager().open(player, player.func_184586_b(hand), PlayerSlot.getSlotForHand(player, hand)), err -> player.func_145747_a(err, player.func_110124_au()));
        }
        return ActionResult.func_226248_a_((Object)stack);
    }

    public void applyNetwork(MinecraftServer server, ItemStack stack, Consumer<INetwork> onNetwork, Consumer<ITextComponent> onError) {
        TranslationTextComponent notFound = new TranslationTextComponent("misc.refinedstorage.network_item.not_found");
        if (!NetworkItem.isValid(stack)) {
            onError.accept((ITextComponent)notFound);
            return;
        }
        RegistryKey<World> dimension = NetworkItem.getDimension(stack);
        if (dimension == null) {
            onError.accept((ITextComponent)notFound);
            return;
        }
        ServerWorld nodeWorld = server.func_71218_a(dimension);
        if (nodeWorld == null) {
            onError.accept((ITextComponent)notFound);
            return;
        }
        INetwork network = NetworkUtils.getNetworkFromNode(NetworkUtils.getNodeFromTile(nodeWorld.func_175625_s(new BlockPos(NetworkItem.getX(stack), NetworkItem.getY(stack), NetworkItem.getZ(stack)))));
        if (network == null) {
            onError.accept((ITextComponent)notFound);
            return;
        }
        onNetwork.accept(network);
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        if (NetworkItem.isValid(stack)) {
            tooltip.add((ITextComponent)new TranslationTextComponent("misc.refinedstorage.network_item.tooltip", new Object[]{NetworkItem.getX(stack), NetworkItem.getY(stack), NetworkItem.getZ(stack)}).func_230530_a_(Styles.GRAY));
        }
    }

    public ActionResultType func_111207_a(ItemStack stack, PlayerEntity playerIn, LivingEntity target, Hand hand) {
        return super.func_111207_a(stack, playerIn, target, hand);
    }

    public ActionResultType func_195939_a(ItemUseContext ctx) {
        ItemStack stack = ctx.func_195999_j().func_184586_b(ctx.func_221531_n());
        INetwork network = NetworkUtils.getNetworkFromNode(NetworkUtils.getNodeFromTile(ctx.func_195991_k().func_175625_s(ctx.func_195995_a())));
        if (network != null) {
            CompoundNBT tag = stack.func_77978_p();
            if (tag == null) {
                tag = new CompoundNBT();
            }
            tag.func_74768_a(NBT_NODE_X, network.getPosition().func_177958_n());
            tag.func_74768_a(NBT_NODE_Y, network.getPosition().func_177956_o());
            tag.func_74768_a(NBT_NODE_Z, network.getPosition().func_177952_p());
            tag.func_74778_a(NBT_DIMENSION, ctx.func_195991_k().func_234923_W_().func_240901_a_().toString());
            stack.func_77982_d(tag);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    @Nullable
    public static RegistryKey<World> getDimension(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b(NBT_DIMENSION)) {
            ResourceLocation name = ResourceLocation.func_208304_a((String)stack.func_77978_p().func_74779_i(NBT_DIMENSION));
            if (name == null) {
                return null;
            }
            return RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)name);
        }
        return null;
    }

    public static int getX(ItemStack stack) {
        return stack.func_77978_p().func_74762_e(NBT_NODE_X);
    }

    public static int getY(ItemStack stack) {
        return stack.func_77978_p().func_74762_e(NBT_NODE_Y);
    }

    public static int getZ(ItemStack stack) {
        return stack.func_77978_p().func_74762_e(NBT_NODE_Z);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public static boolean isValid(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b(NBT_NODE_X) && stack.func_77978_p().func_74764_b(NBT_NODE_Y) && stack.func_77978_p().func_74764_b(NBT_NODE_Z) && stack.func_77978_p().func_74764_b(NBT_DIMENSION);
    }
}

