/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.item;

import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.api.network.node.ICoverable;
import com.refinedmods.refinedstorage.api.network.node.INetworkNode;
import com.refinedmods.refinedstorage.api.network.security.Permission;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.apiimpl.network.node.cover.Cover;
import com.refinedmods.refinedstorage.apiimpl.network.node.cover.CoverManager;
import com.refinedmods.refinedstorage.apiimpl.network.node.cover.CoverType;
import com.refinedmods.refinedstorage.block.CableBlock;
import com.refinedmods.refinedstorage.tile.NetworkNodeTile;
import com.refinedmods.refinedstorage.util.WorldUtils;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.client.model.ModelDataManager;
import net.minecraftforge.registries.ForgeRegistries;

public class CoverItem
extends Item {
    private static final String NBT_ITEM = "Item";
    public static final ItemStack HIDDEN_COVER_ALTERNATIVE = new ItemStack((IItemProvider)Blocks.field_196696_di);

    public CoverItem() {
        super(new Item.Properties().func_200916_a(RS.MAIN_GROUP));
    }

    public static void setItem(ItemStack cover, ItemStack item) {
        if (!cover.func_77942_o()) {
            cover.func_77982_d(new CompoundNBT());
        }
        ItemStack result = item.func_77946_l();
        result.func_190920_e(1);
        cover.func_77978_p().func_218657_a(NBT_ITEM, (INBT)result.serializeNBT());
    }

    @Nonnull
    public static ItemStack getItem(ItemStack cover) {
        if (!cover.func_77942_o() || !cover.func_77978_p().func_74764_b(NBT_ITEM)) {
            return ItemStack.field_190927_a;
        }
        return ItemStack.func_199557_a((CompoundNBT)cover.func_77978_p().func_74775_l(NBT_ITEM));
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        ItemStack item = CoverItem.getItem(stack);
        if (!item.func_190926_b()) {
            tooltip.add((ITextComponent)((TextComponent)item.func_77973_b().func_200295_i(item)).func_240699_a_(TextFormatting.GRAY));
        }
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            if (!RS.CLIENT_CONFIG.getCover().showAllRecipesInJEI()) {
                ItemStack stack = new ItemStack((IItemProvider)this);
                CoverItem.setItem(stack, HIDDEN_COVER_ALTERNATIVE);
                items.add((Object)stack);
                return;
            }
            for (Block block : ForgeRegistries.BLOCKS.getValues()) {
                Item item = Item.func_150898_a((Block)block);
                if (item == Items.field_190931_a) continue;
                NonNullList subBlocks = NonNullList.func_191196_a();
                block.func_149666_a(ItemGroup.field_78027_g, subBlocks);
                for (ItemStack subBlock : subBlocks) {
                    if (!CoverManager.isValidCover(subBlock)) continue;
                    ItemStack stack = new ItemStack((IItemProvider)this);
                    CoverItem.setItem(stack, subBlock);
                    items.add((Object)stack);
                }
            }
        }
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        BlockPos pos = context.func_195995_a();
        Direction facing = context.func_196000_l();
        World world = context.func_195991_k();
        ItemStack stack = context.func_195999_j().func_184586_b(context.func_221531_n());
        TileEntity tile = world.func_175625_s(pos);
        if (!this.canPlaceOn(world, pos, facing)) {
            pos = pos.func_177984_a();
            facing = Direction.DOWN;
            tile = world.func_175625_s(pos);
        }
        if (this.canPlaceOn(world, pos, facing)) {
            if (world.field_72995_K) {
                ModelDataManager.requestModelDataRefresh((TileEntity)tile);
                return ActionResultType.SUCCESS;
            }
            INetworkNode node = ((NetworkNodeTile)tile).getNode();
            if (node.getNetwork() != null && !node.getNetwork().getSecurityManager().hasPermission(Permission.BUILD, context.func_195999_j())) {
                WorldUtils.sendNoPermissionMessage(context.func_195999_j());
                return ActionResultType.FAIL;
            }
            if (((ICoverable)((Object)node)).getCoverManager().setCover(facing, this.createCover(CoverItem.getItem(stack)))) {
                context.func_195999_j().func_184586_b(context.func_221531_n()).func_190918_g(1);
                WorldUtils.updateBlock(world, pos);
                API.instance().getNetworkNodeManager((ServerWorld)world).markForSaving();
                return ActionResultType.SUCCESS;
            }
            return ActionResultType.FAIL;
        }
        return ActionResultType.PASS;
    }

    private boolean canPlaceOn(World world, BlockPos pos, Direction facing) {
        return world.func_175625_s(pos) instanceof NetworkNodeTile && ((NetworkNodeTile)world.func_175625_s(pos)).getNode() instanceof ICoverable && !CableBlock.hasVisualConnectionOnSide(world.func_180495_p(pos), facing);
    }

    protected Cover createCover(ItemStack stack) {
        return new Cover(stack, CoverType.NORMAL);
    }
}

