/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.inventory.item;

import com.refinedmods.refinedstorage.RSItems;
import com.refinedmods.refinedstorage.api.network.grid.IGridTab;
import com.refinedmods.refinedstorage.api.util.IFilter;
import com.refinedmods.refinedstorage.apiimpl.network.grid.GridTab;
import com.refinedmods.refinedstorage.apiimpl.util.FluidFilter;
import com.refinedmods.refinedstorage.apiimpl.util.ItemFilter;
import com.refinedmods.refinedstorage.inventory.fluid.ConfiguredFluidsInFilterItemHandler;
import com.refinedmods.refinedstorage.inventory.item.BaseItemHandler;
import com.refinedmods.refinedstorage.inventory.item.ConfiguredItemsInFilterItemHandler;
import com.refinedmods.refinedstorage.inventory.item.validator.ItemValidator;
import com.refinedmods.refinedstorage.item.FilterItem;
import com.refinedmods.refinedstorage.screen.BaseScreen;
import com.refinedmods.refinedstorage.screen.grid.GridScreen;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.thread.EffectiveSide;

public class FilterItemHandler
extends BaseItemHandler {
    private final List<IFilter> filters;
    private final List<IGridTab> tabs;

    public FilterItemHandler(List<IFilter> filters, List<IGridTab> tabs) {
        super(4);
        this.filters = filters;
        this.tabs = tabs;
        this.addValidator(new ItemValidator((Item)RSItems.FILTER.get()));
    }

    @Override
    protected void onContentsChanged(int slot) {
        super.onContentsChanged(slot);
        this.filters.clear();
        this.tabs.clear();
        for (int i = 0; i < this.getSlots(); ++i) {
            ItemStack filterItem = this.getStackInSlot(i);
            if (filterItem.func_190926_b()) continue;
            this.handleFilterItem(filterItem);
        }
        if (EffectiveSide.get() == LogicalSide.CLIENT) {
            BaseScreen.executeLater(GridScreen.class, grid -> grid.getView().sort());
        }
    }

    private void handleFilterItem(ItemStack filterItem) {
        ItemStack icon = FilterItem.getIcon(filterItem);
        FluidStack fluidIcon = FilterItem.getFluidIcon(filterItem);
        int compare = FilterItem.getCompare(filterItem);
        int mode = FilterItem.getMode(filterItem);
        boolean modFilter = FilterItem.isModFilter(filterItem);
        ArrayList<IFilter> foundFilters = new ArrayList<IFilter>();
        for (ItemStack stack : new ConfiguredItemsInFilterItemHandler(filterItem).getConfiguredItems()) {
            if (stack.func_77973_b() == RSItems.FILTER.get()) {
                this.handleFilterItem(stack);
                continue;
            }
            if (stack.func_190926_b()) continue;
            foundFilters.add(new ItemFilter(stack, compare, mode, modFilter));
        }
        for (ItemStack stack : new ConfiguredFluidsInFilterItemHandler(filterItem).getConfiguredFluids()) {
            foundFilters.add(new FluidFilter((FluidStack)stack, compare, mode, modFilter));
        }
        if (icon.func_190926_b() && fluidIcon.isEmpty()) {
            this.filters.addAll(foundFilters);
        } else {
            this.tabs.add(new GridTab(foundFilters, FilterItem.getName(filterItem), icon, fluidIcon));
        }
    }
}

