/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.block;

import com.refinedmods.refinedstorage.api.network.node.INetworkNode;
import com.refinedmods.refinedstorage.api.network.node.INetworkNodeProxy;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.apiimpl.network.node.NetworkNode;
import com.refinedmods.refinedstorage.block.BaseBlock;
import com.refinedmods.refinedstorage.tile.NetworkNodeTile;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.items.IItemHandler;

public abstract class NetworkNodeBlock
extends BaseBlock {
    public static final BooleanProperty CONNECTED = BooleanProperty.func_177716_a((String)"connected");

    protected NetworkNodeBlock(AbstractBlock.Properties props) {
        super(props);
        if (this.hasConnectedState()) {
            this.func_180632_j((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)CONNECTED, (Comparable)Boolean.valueOf(false)));
        }
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        INetworkNode node;
        super.func_220069_a(state, world, pos, blockIn, fromPos, isMoving);
        if (!world.field_72995_K && (node = API.instance().getNetworkNodeManager((ServerWorld)world).getNode(pos)) instanceof NetworkNode) {
            ((NetworkNode)node).setRedstonePowered(world.func_175640_z(pos));
        }
    }

    @Override
    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        IItemHandler handler;
        TileEntity tile;
        if (state.func_177230_c() != newState.func_177230_c() && (tile = world.func_175625_s(pos)) instanceof NetworkNodeTile && (handler = ((NetworkNode)((NetworkNodeTile)tile).getNode()).getDrops()) != null) {
            NonNullList drops = NonNullList.func_191196_a();
            for (int i = 0; i < handler.getSlots(); ++i) {
                drops.add((Object)handler.getStackInSlot(i));
            }
            InventoryHelper.func_219961_a((World)world, (BlockPos)pos, (NonNullList)drops);
        }
        super.func_196243_a(state, world, pos, newState, isMoving);
    }

    @Override
    protected void onDirectionChanged(World world, BlockPos pos, Direction newDirection) {
        Object node;
        super.onDirectionChanged(world, pos, newDirection);
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof INetworkNodeProxy && (node = ((INetworkNodeProxy)tile).getNode()) instanceof NetworkNode) {
            ((NetworkNode)node).onDirectionChanged(newDirection);
        }
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        if (this.hasConnectedState()) {
            builder.func_206894_a(new Property[]{CONNECTED});
        }
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public boolean hasConnectedState() {
        return false;
    }
}

