/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.block;

import com.refinedmods.refinedstorage.RSBlocks;
import com.refinedmods.refinedstorage.api.network.INetwork;
import com.refinedmods.refinedstorage.api.network.NetworkType;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.apiimpl.network.Network;
import com.refinedmods.refinedstorage.block.BaseBlock;
import com.refinedmods.refinedstorage.container.ControllerContainer;
import com.refinedmods.refinedstorage.tile.ControllerTile;
import com.refinedmods.refinedstorage.util.BlockUtils;
import com.refinedmods.refinedstorage.util.ColorMap;
import com.refinedmods.refinedstorage.util.NetworkUtils;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fml.network.NetworkHooks;

public class ControllerBlock
extends BaseBlock {
    public static final EnumProperty<EnergyType> ENERGY_TYPE = EnumProperty.func_177709_a((String)"energy_type", EnergyType.class);
    private final NetworkType type;

    public ControllerBlock(NetworkType type) {
        super(BlockUtils.DEFAULT_ROCK_PROPERTIES);
        this.type = type;
        this.func_180632_j((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a(ENERGY_TYPE, (Comparable)((Object)EnergyType.OFF)));
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{ENERGY_TYPE});
    }

    public NetworkType getType() {
        return this.type;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new ControllerTile(this.type);
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        super.func_180633_a(world, pos, state, entity, stack);
        if (!world.field_72995_K) {
            stack.getCapability(CapabilityEnergy.ENERGY).ifPresent(energyFromStack -> {
                TileEntity tile = world.func_175625_s(pos);
                if (tile != null) {
                    tile.getCapability(CapabilityEnergy.ENERGY).ifPresent(energyFromTile -> energyFromTile.receiveEnergy(energyFromStack.getEnergyStored(), false));
                }
            });
        }
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        INetwork network;
        super.func_220069_a(state, world, pos, blockIn, fromPos, isMoving);
        if (!world.field_72995_K && (network = API.instance().getNetworkManager((ServerWorld)world).getNetwork(pos)) instanceof Network) {
            ((Network)network).setRedstonePowered(world.func_175640_z(pos));
        }
    }

    public ActionResultType func_225533_a_(BlockState state, final World world, final BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        ActionResultType result = super.func_225533_a_(state, world, pos, player, hand, hit);
        if (result != ActionResultType.PASS) {
            return result;
        }
        ColorMap<ControllerBlock> colorMap = this.type == NetworkType.CREATIVE ? RSBlocks.CREATIVE_CONTROLLER : RSBlocks.CONTROLLER;
        DyeColor color = DyeColor.getColor((ItemStack)player.func_184586_b(hand));
        if (color != null && !state.func_177230_c().equals(colorMap.get(color).get())) {
            BlockState newState = (BlockState)((ControllerBlock)colorMap.get(color).get()).func_176223_P().func_206870_a(ENERGY_TYPE, state.func_177229_b(ENERGY_TYPE));
            return RSBlocks.CONTROLLER.setBlockState(newState, player.func_184586_b(hand), world, pos, player);
        }
        if (!world.field_72995_K) {
            return NetworkUtils.attemptModify(world, pos, player, () -> NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new INamedContainerProvider(){

                public ITextComponent func_145748_c_() {
                    return new TranslationTextComponent("gui.refinedstorage." + (ControllerBlock.this.getType() == NetworkType.CREATIVE ? "creative_" : "") + "controller");
                }

                public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity player) {
                    return new ControllerContainer((ControllerTile)world.func_175625_s(pos), player, i);
                }
            }, (BlockPos)pos));
        }
        return ActionResultType.SUCCESS;
    }

    @Override
    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (newState.func_177230_c() instanceof ControllerBlock) {
            return;
        }
        super.func_196243_a(state, world, pos, newState, isMoving);
    }

    public static enum EnergyType implements IStringSerializable
    {
        OFF("off"),
        NEARLY_OFF("nearly_off"),
        NEARLY_ON("nearly_on"),
        ON("on");

        private final String name;

        private EnergyType(String name) {
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

