/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.block;

import com.refinedmods.refinedstorage.block.BlockDirection;
import com.refinedmods.refinedstorage.block.CableBlock;
import com.refinedmods.refinedstorage.block.shape.ShapeCache;
import com.refinedmods.refinedstorage.container.ConstructorContainer;
import com.refinedmods.refinedstorage.container.factory.PositionalTileContainerProvider;
import com.refinedmods.refinedstorage.render.ConstantsCable;
import com.refinedmods.refinedstorage.tile.ConstructorTile;
import com.refinedmods.refinedstorage.util.BlockUtils;
import com.refinedmods.refinedstorage.util.CollisionUtils;
import com.refinedmods.refinedstorage.util.NetworkUtils;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class ConstructorBlock
extends CableBlock {
    private static final VoxelShape HEAD_NORTH = VoxelShapes.func_197872_a((VoxelShape)ConstructorBlock.func_208617_a((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)14.0, (double)2.0), (VoxelShape)HOLDER_NORTH);
    private static final VoxelShape HEAD_EAST = VoxelShapes.func_197872_a((VoxelShape)ConstructorBlock.func_208617_a((double)14.0, (double)2.0, (double)2.0, (double)16.0, (double)14.0, (double)14.0), (VoxelShape)HOLDER_EAST);
    private static final VoxelShape HEAD_SOUTH = VoxelShapes.func_197872_a((VoxelShape)ConstructorBlock.func_208617_a((double)2.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0, (double)16.0), (VoxelShape)HOLDER_SOUTH);
    private static final VoxelShape HEAD_WEST = VoxelShapes.func_197872_a((VoxelShape)ConstructorBlock.func_208617_a((double)0.0, (double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)14.0), (VoxelShape)HOLDER_WEST);
    private static final VoxelShape HEAD_DOWN = VoxelShapes.func_197872_a((VoxelShape)ConstructorBlock.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)2.0, (double)14.0), (VoxelShape)HOLDER_DOWN);
    private static final VoxelShape HEAD_UP = VoxelShapes.func_197872_a((VoxelShape)ConstructorBlock.func_208617_a((double)2.0, (double)14.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0), (VoxelShape)HOLDER_UP);

    public ConstructorBlock() {
        super(BlockUtils.DEFAULT_GLASS_PROPERTIES);
    }

    @Override
    public BlockDirection getDirection() {
        return BlockDirection.ANY;
    }

    @Override
    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new ConstructorTile();
    }

    @Override
    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext ctx) {
        return ConstantsCable.addCoverVoxelShapes(ShapeCache.getOrCreate(state, s -> {
            VoxelShape shape = ConstructorBlock.getCableShape(s);
            shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)this.getHeadShape((BlockState)s));
            return shape;
        }), world, pos);
    }

    private VoxelShape getHeadShape(BlockState state) {
        Direction direction = (Direction)state.func_177229_b((Property)this.getDirection().getProperty());
        if (direction == Direction.NORTH) {
            return HEAD_NORTH;
        }
        if (direction == Direction.EAST) {
            return HEAD_EAST;
        }
        if (direction == Direction.SOUTH) {
            return HEAD_SOUTH;
        }
        if (direction == Direction.WEST) {
            return HEAD_WEST;
        }
        if (direction == Direction.UP) {
            return HEAD_UP;
        }
        if (direction == Direction.DOWN) {
            return HEAD_DOWN;
        }
        return VoxelShapes.func_197880_a();
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (!world.field_72995_K && CollisionUtils.isInBounds(this.getHeadShape(state), pos, hit.func_216347_e())) {
            return NetworkUtils.attemptModify(world, pos, player, () -> NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), new PositionalTileContainerProvider<ConstructorTile>((ITextComponent)new TranslationTextComponent("gui.refinedstorage.constructor"), (tile, windowId, inventory, p) -> new ConstructorContainer((ConstructorTile)tile, player, windowId), pos), (BlockPos)pos));
        }
        return ActionResultType.SUCCESS;
    }

    @Override
    public boolean hasConnectedState() {
        return true;
    }
}

