/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.network.node.diskmanipulator;

import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.api.storage.AccessType;
import com.refinedmods.refinedstorage.api.storage.disk.IStorageDisk;
import com.refinedmods.refinedstorage.api.storage.disk.IStorageDiskContainerContext;
import com.refinedmods.refinedstorage.api.util.Action;
import com.refinedmods.refinedstorage.api.util.StackListEntry;
import com.refinedmods.refinedstorage.apiimpl.network.node.DiskState;
import com.refinedmods.refinedstorage.apiimpl.network.node.NetworkNode;
import com.refinedmods.refinedstorage.apiimpl.network.node.diskmanipulator.StorageDiskFluidManipulatorWrapper;
import com.refinedmods.refinedstorage.apiimpl.network.node.diskmanipulator.StorageDiskItemManipulatorWrapper;
import com.refinedmods.refinedstorage.inventory.fluid.FluidInventory;
import com.refinedmods.refinedstorage.inventory.item.BaseItemHandler;
import com.refinedmods.refinedstorage.inventory.item.ProxyItemHandler;
import com.refinedmods.refinedstorage.inventory.item.UpgradeItemHandler;
import com.refinedmods.refinedstorage.inventory.item.validator.StorageDiskItemValidator;
import com.refinedmods.refinedstorage.inventory.listener.NetworkNodeFluidInventoryListener;
import com.refinedmods.refinedstorage.inventory.listener.NetworkNodeInventoryListener;
import com.refinedmods.refinedstorage.item.UpgradeItem;
import com.refinedmods.refinedstorage.tile.DiskManipulatorTile;
import com.refinedmods.refinedstorage.tile.config.IComparable;
import com.refinedmods.refinedstorage.tile.config.IType;
import com.refinedmods.refinedstorage.tile.config.IWhitelistBlacklist;
import com.refinedmods.refinedstorage.util.StackUtils;
import com.refinedmods.refinedstorage.util.WorldUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class DiskManipulatorNetworkNode
extends NetworkNode
implements IComparable,
IWhitelistBlacklist,
IType,
IStorageDiskContainerContext {
    public static final ResourceLocation ID = new ResourceLocation("refinedstorage", "disk_manipulator");
    public static final int IO_MODE_INSERT = 0;
    public static final int IO_MODE_EXTRACT = 1;
    private static final String NBT_COMPARE = "Compare";
    private static final String NBT_MODE = "Mode";
    private static final String NBT_TYPE = "Type";
    private static final String NBT_IO_MODE = "IOMode";
    private static final String NBT_FLUID_FILTERS = "FluidFilters";
    private int compare = 1;
    private int mode = 1;
    private int type = 0;
    private int ioMode = 0;
    private final IStorageDisk<ItemStack>[] itemDisks = new IStorageDisk[6];
    private final IStorageDisk<FluidStack>[] fluidDisks = new IStorageDisk[6];
    private final UpgradeItemHandler upgrades = (UpgradeItemHandler)new UpgradeItemHandler(4, new UpgradeItem.Type[]{UpgradeItem.Type.SPEED, UpgradeItem.Type.STACK}){

        @Override
        public int getStackInteractCount() {
            int count = super.getStackInteractCount();
            if (DiskManipulatorNetworkNode.this.type == 1) {
                count *= 1000;
            }
            return count;
        }
    }.addListener(new NetworkNodeInventoryListener(this));
    private final BaseItemHandler inputDisks = new BaseItemHandler(3).addValidator(new StorageDiskItemValidator()).addListener(new NetworkNodeInventoryListener(this)).addListener((handler, slot, reading) -> {
        if (!this.world.field_72995_K) {
            StackUtils.createStorages((ServerWorld)this.world, handler.getStackInSlot(slot), slot, this.itemDisks, this.fluidDisks, s -> new StorageDiskItemManipulatorWrapper(this, (IStorageDisk<ItemStack>)s), s -> new StorageDiskFluidManipulatorWrapper(this, (IStorageDisk<FluidStack>)s));
            if (!reading) {
                WorldUtils.updateBlock(this.world, this.pos);
            }
        }
    });
    private final BaseItemHandler outputDisks = new BaseItemHandler(3).addValidator(new StorageDiskItemValidator()).addListener(new NetworkNodeInventoryListener(this)).addListener((handler, slot, reading) -> {
        if (!this.world.field_72995_K) {
            StackUtils.createStorages((ServerWorld)this.world, handler.getStackInSlot(slot), 3 + slot, this.itemDisks, this.fluidDisks, s -> new StorageDiskItemManipulatorWrapper(this, (IStorageDisk<ItemStack>)s), s -> new StorageDiskFluidManipulatorWrapper(this, (IStorageDisk<FluidStack>)s));
            if (!reading) {
                WorldUtils.updateBlock(this.world, this.pos);
            }
        }
    });
    private final ProxyItemHandler disks = new ProxyItemHandler((IItemHandler)this.inputDisks, (IItemHandler)this.outputDisks);
    private final BaseItemHandler itemFilters = new BaseItemHandler(9).addListener(new NetworkNodeInventoryListener(this));
    private final FluidInventory fluidFilters = new FluidInventory(9).addListener(new NetworkNodeFluidInventoryListener(this));

    public DiskManipulatorNetworkNode(World world, BlockPos pos) {
        super(world, pos);
    }

    @Override
    public int getEnergyUsage() {
        return RS.SERVER_CONFIG.getDiskManipulator().getUsage() + this.upgrades.getEnergyUsage();
    }

    @Override
    public void update() {
        int slot;
        super.update();
        if (!this.canUpdate() || this.ticks % this.upgrades.getSpeed() != 0) {
            return;
        }
        if (this.type == 0) {
            for (slot = 0; slot < 3 && (this.itemDisks[slot] == null || this.isItemDiskDone(this.itemDisks[slot], slot)); ++slot) {
            }
            if (slot == 3) {
                return;
            }
            IStorageDisk<ItemStack> storage = this.itemDisks[slot];
            if (this.ioMode == 0) {
                this.insertItemIntoNetwork(storage);
            } else if (this.ioMode == 1) {
                this.extractItemFromNetwork(storage, slot);
            }
        } else if (this.type == 1) {
            while (slot < 3 && (this.fluidDisks[slot] == null || this.isFluidDiskDone(this.fluidDisks[slot], slot))) {
                ++slot;
            }
            if (slot == 3) {
                return;
            }
            IStorageDisk<FluidStack> storage = this.fluidDisks[slot];
            if (this.ioMode == 0) {
                this.insertFluidIntoNetwork(storage, slot);
            } else if (this.ioMode == 1) {
                this.extractFluidFromNetwork(storage, slot);
            }
        }
    }

    private void insertItemIntoNetwork(IStorageDisk<ItemStack> storage) {
        ArrayList stacks = new ArrayList(storage.getStacks());
        for (int i = 0; i < stacks.size(); ++i) {
            ItemStack stack = (ItemStack)stacks.get(i);
            ItemStack extracted = storage.extract(stack, this.upgrades.getStackInteractCount(), this.compare, Action.PERFORM);
            if (extracted.func_190926_b()) continue;
            ItemStack remainder = this.network.insertItem(extracted, extracted.func_190916_E(), Action.PERFORM);
            if (remainder.func_190926_b()) break;
            storage.insert(extracted == remainder ? remainder.func_77946_l() : remainder, remainder.func_190916_E(), Action.PERFORM);
        }
    }

    private boolean isItemDiskDone(IStorageDisk<ItemStack> storage, int slot) {
        if (this.ioMode == 0 && storage.getStored() == 0) {
            this.moveDriveToOutput(slot);
            return true;
        }
        if (this.ioMode == 1) {
            if (storage.getStored() == storage.getCapacity()) {
                this.moveDriveToOutput(slot);
                return true;
            }
            return false;
        }
        ArrayList stacks = new ArrayList(storage.getStacks());
        for (int i = 0; i < stacks.size(); ++i) {
            ItemStack remainder;
            ItemStack stack = (ItemStack)stacks.get(i);
            ItemStack extracted = storage.extract(stack, this.upgrades.getStackInteractCount(), this.compare, Action.SIMULATE);
            if (extracted.func_190926_b() || !(remainder = this.network.insertItem(extracted, extracted.func_190916_E(), Action.SIMULATE)).func_190926_b()) continue;
            return false;
        }
        return true;
    }

    private void extractItemFromNetwork(IStorageDisk<ItemStack> storage, int slot) {
        ItemStack extracted = ItemStack.field_190927_a;
        int i = 0;
        if (this.itemFilters.isEmpty()) {
            ItemStack toExtract = null;
            List networkItems = this.network.getItemStorageCache().getList().getStacks().stream().map(StackListEntry::getStack).collect(Collectors.toList());
            int j = 0;
            while ((toExtract == null || toExtract.func_190926_b()) && j < networkItems.size()) {
                toExtract = (ItemStack)networkItems.get(j++);
            }
            if (toExtract != null) {
                extracted = this.network.extractItem(toExtract, this.upgrades.getStackInteractCount(), this.compare, Action.PERFORM);
            }
        } else {
            while (this.itemFilters.getSlots() > i && extracted.func_190926_b()) {
                ItemStack filterStack = ItemStack.field_190927_a;
                while (this.itemFilters.getSlots() > i && filterStack.func_190926_b()) {
                    filterStack = this.itemFilters.getStackInSlot(i++);
                }
                if (filterStack.func_190926_b()) continue;
                extracted = this.network.extractItem(filterStack, this.upgrades.getStackInteractCount(), this.compare, Action.PERFORM);
            }
        }
        if (extracted.func_190926_b()) {
            this.moveDriveToOutput(slot);
            return;
        }
        ItemStack remainder = storage.insert(extracted, extracted.func_190916_E(), Action.PERFORM);
        this.network.insertItem(remainder, remainder.func_190916_E(), Action.PERFORM);
    }

    private void insertFluidIntoNetwork(IStorageDisk<FluidStack> storage, int slot) {
        ArrayList stacks = new ArrayList(storage.getStacks());
        FluidStack extracted = FluidStack.EMPTY;
        int i = 0;
        while (extracted.isEmpty() && stacks.size() > i) {
            FluidStack stack = (FluidStack)stacks.get(i++);
            extracted = storage.extract(stack, this.upgrades.getStackInteractCount(), this.compare, Action.PERFORM);
        }
        if (extracted.isEmpty()) {
            this.moveDriveToOutput(slot);
            return;
        }
        FluidStack remainder = this.network.insertFluid(extracted, extracted.getAmount(), Action.PERFORM);
        storage.insert(remainder, remainder.getAmount(), Action.PERFORM);
    }

    private boolean isFluidDiskDone(IStorageDisk<FluidStack> storage, int slot) {
        if (this.ioMode == 0 && storage.getStored() == 0) {
            this.moveDriveToOutput(slot);
            return true;
        }
        if (this.ioMode == 1) {
            if (storage.getStored() == storage.getCapacity()) {
                this.moveDriveToOutput(slot);
                return true;
            }
            return false;
        }
        ArrayList stacks = new ArrayList(storage.getStacks());
        for (int i = 0; i < stacks.size(); ++i) {
            FluidStack remainder;
            FluidStack stack = (FluidStack)stacks.get(i);
            FluidStack extracted = storage.extract(stack, this.upgrades.getStackInteractCount(), this.compare, Action.SIMULATE);
            if (extracted.isEmpty() || !(remainder = this.network.insertFluid(extracted, extracted.getAmount(), Action.SIMULATE)).isEmpty()) continue;
            return false;
        }
        return true;
    }

    private void extractFluidFromNetwork(IStorageDisk<FluidStack> storage, int slot) {
        FluidStack extracted = FluidStack.EMPTY;
        int i = 0;
        if (this.fluidFilters.isEmpty()) {
            FluidStack toExtract = null;
            List networkFluids = this.network.getFluidStorageCache().getList().getStacks().stream().map(StackListEntry::getStack).collect(Collectors.toList());
            int j = 0;
            while ((toExtract == null || toExtract.getAmount() == 0) && j < networkFluids.size()) {
                toExtract = (FluidStack)networkFluids.get(j++);
            }
            if (toExtract != null) {
                extracted = this.network.extractFluid(toExtract, this.upgrades.getStackInteractCount(), this.compare, Action.PERFORM);
            }
        } else {
            while (this.fluidFilters.getSlots() > i && extracted.isEmpty()) {
                FluidStack filterStack = FluidStack.EMPTY;
                while (this.fluidFilters.getSlots() > i && filterStack.isEmpty()) {
                    filterStack = this.fluidFilters.getFluid(i++);
                }
                if (filterStack.isEmpty()) continue;
                extracted = this.network.extractFluid(filterStack, this.upgrades.getStackInteractCount(), this.compare, Action.PERFORM);
            }
        }
        if (extracted.isEmpty()) {
            this.moveDriveToOutput(slot);
            return;
        }
        FluidStack remainder = storage.insert(extracted, extracted.getAmount(), Action.PERFORM);
        this.network.insertFluid(remainder, remainder.getAmount(), Action.PERFORM);
    }

    private void moveDriveToOutput(int slot) {
        ItemStack disk = this.inputDisks.getStackInSlot(slot);
        if (!disk.func_190926_b()) {
            int i;
            for (i = 0; i < 3 && !this.outputDisks.getStackInSlot(i).func_190926_b(); ++i) {
            }
            if (i == 3) {
                return;
            }
            this.inputDisks.extractItem(slot, 1, false);
            this.outputDisks.insertItem(i, disk, false);
        }
    }

    public DiskState[] getDiskState() {
        DiskState[] diskStates = new DiskState[6];
        for (int i = 0; i < 6; ++i) {
            DiskState state = DiskState.NONE;
            if (this.itemDisks[i] != null || this.fluidDisks[i] != null) {
                state = !this.canUpdate() ? DiskState.DISCONNECTED : DiskState.get(this.itemDisks[i] != null ? this.itemDisks[i].getStored() : this.fluidDisks[i].getStored(), this.itemDisks[i] != null ? this.itemDisks[i].getCapacity() : this.fluidDisks[i].getCapacity());
            }
            diskStates[i] = state;
        }
        return diskStates;
    }

    @Override
    public int getCompare() {
        return this.compare;
    }

    @Override
    public void setCompare(int compare) {
        this.compare = compare;
    }

    @Override
    public int getType() {
        return this.world.field_72995_K ? DiskManipulatorTile.TYPE.getValue() : this.type;
    }

    @Override
    public void setType(int type) {
        this.type = type;
    }

    @Override
    public IItemHandlerModifiable getItemFilters() {
        return this.itemFilters;
    }

    @Override
    public FluidInventory getFluidFilters() {
        return this.fluidFilters;
    }

    @Override
    public void setWhitelistBlacklistMode(int mode) {
        this.mode = mode;
    }

    @Override
    public int getWhitelistBlacklistMode() {
        return this.mode;
    }

    public int getIoMode() {
        return this.ioMode;
    }

    public void setIoMode(int ioMode) {
        this.ioMode = ioMode;
    }

    public IItemHandler getInputDisks() {
        return this.inputDisks;
    }

    public IItemHandler getOutputDisks() {
        return this.outputDisks;
    }

    public ProxyItemHandler getDisks() {
        return this.disks;
    }

    public IItemHandler getUpgrades() {
        return this.upgrades;
    }

    @Override
    public void read(CompoundNBT tag) {
        super.read(tag);
        StackUtils.readItems(this.upgrades, 3, tag);
        StackUtils.readItems(this.inputDisks, 4, tag);
        StackUtils.readItems(this.outputDisks, 5, tag);
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public CompoundNBT write(CompoundNBT tag) {
        super.write(tag);
        StackUtils.writeItems((IItemHandler)this.upgrades, 3, tag);
        StackUtils.writeItems((IItemHandler)this.inputDisks, 4, tag);
        StackUtils.writeItems((IItemHandler)this.outputDisks, 5, tag);
        return tag;
    }

    @Override
    public CompoundNBT writeConfiguration(CompoundNBT tag) {
        super.writeConfiguration(tag);
        StackUtils.writeItems((IItemHandler)this.itemFilters, 1, tag);
        tag.func_218657_a(NBT_FLUID_FILTERS, (INBT)this.fluidFilters.writeToNbt());
        tag.func_74768_a(NBT_COMPARE, this.compare);
        tag.func_74768_a(NBT_MODE, this.mode);
        tag.func_74768_a(NBT_TYPE, this.type);
        tag.func_74768_a(NBT_IO_MODE, this.ioMode);
        return tag;
    }

    @Override
    public void readConfiguration(CompoundNBT tag) {
        super.readConfiguration(tag);
        StackUtils.readItems(this.itemFilters, 1, tag);
        if (tag.func_74764_b(NBT_FLUID_FILTERS)) {
            this.fluidFilters.readFromNbt(tag.func_74775_l(NBT_FLUID_FILTERS));
        }
        if (tag.func_74764_b(NBT_COMPARE)) {
            this.compare = tag.func_74762_e(NBT_COMPARE);
        }
        if (tag.func_74764_b(NBT_MODE)) {
            this.mode = tag.func_74762_e(NBT_MODE);
        }
        if (tag.func_74764_b(NBT_TYPE)) {
            this.type = tag.func_74762_e(NBT_TYPE);
        }
        if (tag.func_74764_b(NBT_IO_MODE)) {
            this.ioMode = tag.func_74762_e(NBT_IO_MODE);
        }
    }

    @Override
    public IItemHandler getDrops() {
        return new CombinedInvWrapper(new IItemHandlerModifiable[]{this.inputDisks, this.outputDisks, this.upgrades});
    }

    @Override
    public AccessType getAccessType() {
        return AccessType.INSERT_EXTRACT;
    }
}

