/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.network;

import com.google.common.collect.Sets;
import com.refinedmods.refinedstorage.api.network.INetwork;
import com.refinedmods.refinedstorage.api.network.INetworkNodeGraph;
import com.refinedmods.refinedstorage.api.network.INetworkNodeGraphEntry;
import com.refinedmods.refinedstorage.api.network.INetworkNodeGraphListener;
import com.refinedmods.refinedstorage.api.network.INetworkNodeVisitor;
import com.refinedmods.refinedstorage.api.network.node.INetworkNode;
import com.refinedmods.refinedstorage.api.util.Action;
import com.refinedmods.refinedstorage.apiimpl.network.NetworkNodeGraphEntry;
import com.refinedmods.refinedstorage.util.NetworkUtils;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class NetworkNodeGraph
implements INetworkNodeGraph {
    private final INetwork network;
    private Set<INetworkNodeGraphEntry> entries = Sets.newConcurrentHashSet();
    private final List<INetworkNodeGraphListener> listeners = new LinkedList<INetworkNodeGraphListener>();
    private final Set<Consumer<INetwork>> actions = new HashSet<Consumer<INetwork>>();
    private boolean invalidating = false;

    public NetworkNodeGraph(INetwork network) {
        this.network = network;
    }

    @Override
    public void invalidate(Action action, World world, BlockPos origin) {
        Visitor currentVisitor;
        this.invalidating = true;
        Operator operator = new Operator(action);
        INetworkNode originNode = NetworkUtils.getNodeFromTile(world.func_175625_s(origin));
        if (originNode instanceof INetworkNodeVisitor) {
            ((INetworkNodeVisitor)((Object)originNode)).visit(operator);
        }
        while ((currentVisitor = (Visitor)operator.toCheck.poll()) != null) {
            currentVisitor.visit(operator);
        }
        this.entries = operator.foundNodes;
        if (action == Action.PERFORM) {
            for (INetworkNodeGraphEntry entry : operator.newEntries) {
                entry.getNode().onConnected(this.network);
            }
            for (INetworkNodeGraphEntry entry : operator.previousEntries) {
                entry.getNode().onDisconnected(this.network);
            }
            this.actions.forEach(h -> h.accept(this.network));
            this.actions.clear();
            if (!operator.newEntries.isEmpty() || !operator.previousEntries.isEmpty()) {
                this.listeners.forEach(INetworkNodeGraphListener::onChanged);
            }
        }
        this.invalidating = false;
    }

    @Override
    public void runActionWhenPossible(Consumer<INetwork> handler) {
        if (this.invalidating) {
            this.actions.add(handler);
        } else {
            handler.accept(this.network);
        }
    }

    @Override
    public Collection<INetworkNodeGraphEntry> all() {
        return this.entries;
    }

    @Override
    public void addListener(INetworkNodeGraphListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void disconnectAll() {
        this.entries.forEach(entry -> entry.getNode().onDisconnected(this.network));
        this.entries.clear();
        this.listeners.forEach(INetworkNodeGraphListener::onChanged);
    }

    protected World getWorld() {
        return this.network.getWorld();
    }

    private static class Visitor
    implements INetworkNodeVisitor {
        private final INetworkNode node;
        private final World world;
        private final BlockPos pos;
        private final Direction side;
        private final TileEntity tile;

        Visitor(INetworkNode node, World world, BlockPos pos, Direction side, TileEntity tile) {
            this.node = node;
            this.world = world;
            this.pos = pos;
            this.side = side;
            this.tile = tile;
        }

        @Override
        public void visit(INetworkNodeVisitor.Operator operator) {
            if (this.node instanceof INetworkNodeVisitor) {
                ((INetworkNodeVisitor)((Object)this.node)).visit(operator);
            } else {
                for (Direction checkSide : Direction.values()) {
                    INetworkNode nodeOnSide;
                    if (checkSide == this.side || (nodeOnSide = NetworkUtils.getNodeFromTile(this.tile)) != this.node) continue;
                    operator.apply(this.world, this.pos.func_177972_a(checkSide), checkSide.func_176734_d());
                }
            }
        }
    }

    private class Operator
    implements INetworkNodeVisitor.Operator {
        private final Set<INetworkNodeGraphEntry> foundNodes = Sets.newConcurrentHashSet();
        private final Set<INetworkNodeGraphEntry> newEntries = Sets.newConcurrentHashSet();
        private final Set<INetworkNodeGraphEntry> previousEntries = Sets.newConcurrentHashSet((Iterable)NetworkNodeGraph.access$400(NetworkNodeGraph.this));
        private final Queue<Visitor> toCheck = new ArrayDeque<Visitor>();
        private final Action action;

        public Operator(Action action) {
            this.action = action;
        }

        @Override
        public void apply(World world, BlockPos pos, @Nullable Direction side) {
            TileEntity tile = world.func_175625_s(pos);
            INetworkNode otherNode = NetworkUtils.getNodeFromTile(tile);
            if (otherNode != null) {
                NetworkNodeGraphEntry otherNodeItem = new NetworkNodeGraphEntry(otherNode);
                if (otherNode.getNetwork() != null && !otherNode.getNetwork().equals(NetworkNodeGraph.this.network)) {
                    if (this.action == Action.PERFORM) {
                        this.dropConflictingBlock(world, pos);
                    }
                    return;
                }
                if (this.foundNodes.add(otherNodeItem)) {
                    if (!NetworkNodeGraph.this.entries.contains(otherNodeItem)) {
                        this.newEntries.add(otherNodeItem);
                    }
                    this.previousEntries.remove(otherNodeItem);
                    this.toCheck.add(new Visitor(otherNode, world, pos, side, tile));
                }
            }
        }

        private void dropConflictingBlock(World world, BlockPos pos) {
            if (!NetworkNodeGraph.this.network.getPosition().equals((Object)pos)) {
                Block.func_220059_a((BlockState)world.func_180495_p(pos), (IWorld)world, (BlockPos)pos, (TileEntity)world.func_175625_s(pos));
                world.func_217377_a(pos, false);
            }
        }

        @Override
        public Action getAction() {
            return this.action;
        }
    }
}

