/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.network.node;

import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.apiimpl.network.node.NetworkNode;
import com.refinedmods.refinedstorage.block.CrafterManagerBlock;
import com.refinedmods.refinedstorage.block.NetworkNodeBlock;
import com.refinedmods.refinedstorage.tile.CrafterManagerTile;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class CrafterManagerNetworkNode
extends NetworkNode {
    public static final ResourceLocation ID = new ResourceLocation("refinedstorage", "crafter_manager");
    private static final String NBT_SIZE = "Size";
    private static final String NBT_SEARCH_BOX_MODE = "SearchBoxMode";
    private int size = 0;
    private int searchBoxMode = 0;

    public CrafterManagerNetworkNode(World world, BlockPos pos) {
        super(world, pos);
    }

    @Override
    public int getEnergyUsage() {
        return RS.SERVER_CONFIG.getCrafterManager().getUsage();
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    public int getSize() {
        return this.world.field_72995_K ? CrafterManagerTile.SIZE.getValue() : this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    @Override
    public CompoundNBT writeConfiguration(CompoundNBT tag) {
        super.writeConfiguration(tag);
        tag.func_74768_a(NBT_SIZE, this.size);
        tag.func_74768_a(NBT_SEARCH_BOX_MODE, this.searchBoxMode);
        return tag;
    }

    @Override
    public void readConfiguration(CompoundNBT tag) {
        super.readConfiguration(tag);
        if (tag.func_74764_b(NBT_SIZE)) {
            this.size = tag.func_74762_e(NBT_SIZE);
        }
        if (tag.func_74764_b(NBT_SEARCH_BOX_MODE)) {
            this.searchBoxMode = tag.func_74762_e(NBT_SEARCH_BOX_MODE);
        }
    }

    public int getSearchBoxMode() {
        return this.world.field_72995_K ? CrafterManagerTile.SEARCH_BOX_MODE.getValue() : this.searchBoxMode;
    }

    public void setSearchBoxMode(int searchBoxMode) {
        this.searchBoxMode = searchBoxMode;
    }

    public boolean isActiveOnClient() {
        BlockState state = this.world.func_180495_p(this.pos);
        if (state.func_177230_c() instanceof CrafterManagerBlock) {
            return (Boolean)state.func_177229_b((Property)NetworkNodeBlock.CONNECTED);
        }
        return false;
    }
}

