/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.autocrafting.task.v6;

import com.refinedmods.refinedstorage.api.autocrafting.ICraftingPattern;
import com.refinedmods.refinedstorage.apiimpl.API;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.FluidStack;

public class CraftingPatternInputs {
    private final NonNullList<ItemStack> recipe = NonNullList.func_191196_a();
    private final List<Ingredient<ItemStack>> itemIngredients = new ArrayList<Ingredient<ItemStack>>();
    private final List<Ingredient<FluidStack>> fluidIngredients = new ArrayList<Ingredient<FluidStack>>();

    public CraftingPatternInputs(ICraftingPattern pattern) {
        this.fillOutRecipe(pattern);
        this.combineItemInputs(pattern);
        this.combineFluidInputs(pattern);
    }

    private void fillOutRecipe(ICraftingPattern pattern) {
        for (NonNullList<ItemStack> inputsForSlot : pattern.getInputs()) {
            if (inputsForSlot.isEmpty()) {
                this.recipe.add((Object)ItemStack.field_190927_a);
                continue;
            }
            this.recipe.add(inputsForSlot.get(0));
        }
    }

    private void combineItemInputs(ICraftingPattern pattern) {
        for (NonNullList<ItemStack> inputsForSlot : pattern.getInputs()) {
            if (inputsForSlot.isEmpty()) continue;
            Ingredient<ItemStack> matchingIngredient = this.findMatchingItemIngredient(inputsForSlot);
            if (matchingIngredient == null) {
                this.itemIngredients.add(new Ingredient<ItemStack>(inputsForSlot, ((ItemStack)inputsForSlot.get(0)).func_190916_E()));
                continue;
            }
            matchingIngredient.increaseCount(((ItemStack)inputsForSlot.get(0)).func_190916_E());
        }
    }

    private void combineFluidInputs(ICraftingPattern pattern) {
        for (NonNullList<FluidStack> inputsForSlot : pattern.getFluidInputs()) {
            if (inputsForSlot.isEmpty()) continue;
            Ingredient<FluidStack> matchingIngredient = this.findMatchingFluidIngredient(inputsForSlot);
            if (matchingIngredient == null) {
                this.fluidIngredients.add(new Ingredient<FluidStack>(inputsForSlot, ((FluidStack)inputsForSlot.get(0)).getAmount()));
                continue;
            }
            matchingIngredient.increaseCount(((FluidStack)inputsForSlot.get(0)).getAmount());
        }
    }

    @Nullable
    private Ingredient<ItemStack> findMatchingItemIngredient(NonNullList<ItemStack> inputsForSlot) {
        for (Ingredient<ItemStack> existingIngredient : this.itemIngredients) {
            if (existingIngredient.getInputs().size() != inputsForSlot.size()) continue;
            boolean found = true;
            for (int i = 0; i < inputsForSlot.size(); ++i) {
                if (API.instance().getComparer().isEqualNoQuantity((ItemStack)existingIngredient.getInputs().get(i), (ItemStack)inputsForSlot.get(i))) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return existingIngredient;
        }
        return null;
    }

    @Nullable
    private Ingredient<FluidStack> findMatchingFluidIngredient(NonNullList<FluidStack> inputsForSlot) {
        for (Ingredient<FluidStack> existingIngredient : this.fluidIngredients) {
            if (existingIngredient.getInputs().size() != inputsForSlot.size()) continue;
            boolean found = true;
            for (int i = 0; i < inputsForSlot.size(); ++i) {
                if (API.instance().getComparer().isEqual((FluidStack)existingIngredient.getInputs().get(i), (FluidStack)inputsForSlot.get(i), 1)) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return existingIngredient;
        }
        return null;
    }

    public NonNullList<ItemStack> getRecipe() {
        return this.recipe;
    }

    public List<Ingredient<ItemStack>> getItemIngredients() {
        return this.itemIngredients;
    }

    public List<Ingredient<FluidStack>> getFluidIngredients() {
        return this.fluidIngredients;
    }

    public static class Ingredient<T> {
        private final NonNullList<T> inputs;
        private int count;

        public Ingredient(NonNullList<T> inputs, int count) {
            this.inputs = inputs;
            this.count = count;
        }

        public NonNullList<T> getInputs() {
            return this.inputs;
        }

        public int getCount() {
            return this.count;
        }

        public void increaseCount(int count) {
            this.count += count;
        }
    }
}

