/*
 * Decompiled with CFR 0.152.
 */
package net.permutated.pylons.util;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.SectionPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.permutated.pylons.util.Location;
import net.permutated.pylons.util.Range;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="pylons")
public class SpawnManager {
    private static boolean dirty = false;
    private static Map<Location, Set<String>> chunkMap = new ConcurrentHashMap<Location, Set<String>>();
    private static final Map<Location, Pair<Set<Location>, Set<String>>> pylonMap = new ConcurrentHashMap<Location, Pair<Set<Location>, Set<String>>>();

    private SpawnManager() {
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase.equals((Object)TickEvent.Phase.END) && dirty) {
            ConcurrentHashMap<Location, Set<String>> replace = new ConcurrentHashMap<Location, Set<String>>();
            pylonMap.values().forEach(pair -> ((Set)pair.getLeft()).forEach(location -> replace.merge((Location)location, (Set<String>)pair.getRight(), Sets::union)));
            chunkMap = replace;
            dirty = false;
        }
    }

    @SubscribeEvent
    public static void onEntityJoinWorldEvent(EntityJoinWorldEvent event) {
        if (event.getWorld() instanceof ServerWorld && event.getEntity() instanceof LivingEntity) {
            ServerWorld level = (ServerWorld)event.getWorld();
            LivingEntity entity = (LivingEntity)event.getEntity();
            int chunkX = SectionPos.func_218159_a((int)((int)entity.func_226277_ct_()));
            int chunkZ = SectionPos.func_218159_a((int)((int)entity.func_226281_cx_()));
            Location key = new Location((RegistryKey<World>)level.func_234923_W_(), BlockPos.field_177992_a, chunkX, chunkZ);
            Set<String> filterSet = chunkMap.get(key);
            if (filterSet == null) {
                return;
            }
            String registryId = Objects.toString(event.getEntity().func_200600_R().getRegistryName(), "unregistered");
            if (filterSet.contains(registryId)) {
                event.setCanceled(true);
            }
        }
    }

    public static void register(ServerWorld level, BlockPos blockPos, Range range, Collection<String> filters) {
        if (filters.isEmpty()) {
            return;
        }
        Location pylon = Location.of(level, blockPos);
        Set<Location> locations = Location.chunkSet(level, blockPos, range);
        pylonMap.put(pylon, (Pair<Set<Location>, Set<String>>)Pair.of(locations, (Object)ImmutableSet.copyOf(filters)));
        dirty = true;
    }

    public static void unregister(ServerWorld level, BlockPos blockPos) {
        Location pylon = Location.of(level, blockPos);
        pylonMap.remove(pylon);
        dirty = true;
    }
}

