/*
 * Decompiled with CFR 0.152.
 */
package net.permutated.pylons.util;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.SectionPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.permutated.pylons.util.Range;

public class Location {
    protected final RegistryKey<World> level;
    protected final BlockPos blockPos;
    protected final int chunkX;
    protected final int chunkZ;

    public Location(RegistryKey<World> level, BlockPos blockPos, int chunkX, int chunkZ) {
        this.level = level;
        this.blockPos = blockPos;
        this.chunkX = chunkX;
        this.chunkZ = chunkZ;
    }

    public static Location of(ServerWorld level, BlockPos blockPos) {
        int chunkX = SectionPos.func_218159_a((int)blockPos.func_177958_n());
        int chunkZ = SectionPos.func_218159_a((int)blockPos.func_177952_p());
        return new Location((RegistryKey<World>)level.func_234923_W_(), blockPos, chunkX, chunkZ);
    }

    public static Set<Location> chunkSet(ServerWorld level, BlockPos blockPos, Range range) {
        HashSet<Location> locations = new HashSet<Location>();
        int chunkX = SectionPos.func_218159_a((int)blockPos.func_177958_n());
        int chunkZ = SectionPos.func_218159_a((int)blockPos.func_177952_p());
        int radius = range.toRadius();
        int minChunkX = chunkX - radius;
        int minChunkZ = chunkZ - radius;
        int maxChunkX = chunkX + radius;
        int maxChunkZ = chunkZ + radius;
        for (int x = minChunkX; x <= maxChunkX; ++x) {
            for (int z = minChunkZ; z <= maxChunkZ; ++z) {
                locations.add(new Location((RegistryKey<World>)level.func_234923_W_(), BlockPos.field_177992_a, x, z));
            }
        }
        return locations;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Location)) {
            return false;
        }
        Location location = (Location)o;
        return this.chunkX == location.chunkX && this.chunkZ == location.chunkZ && this.level.equals(location.level) && this.blockPos.equals((Object)location.blockPos);
    }

    public int hashCode() {
        return Objects.hash(this.level, this.blockPos, this.chunkX, this.chunkZ);
    }

    public String toString() {
        return "Location{level=" + this.level + ", blockPos=" + this.blockPos + ", chunkX=" + this.chunkX + ", chunkZ=" + this.chunkZ + '}';
    }
}

